<?php

namespace Frontdesk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientRequestModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientRequestModel
 * @subpackage Structs
 */
class ClientRequestModel extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Amount;
    /**
     * The BackendURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackendURL;
    /**
     * The BarcodeNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeNo;
    /**
     * The CCCId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCCId;
    /**
     * The CCCOriTokenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCCOriTokenId;
    /**
     * The CCMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCMonth;
    /**
     * The CCName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCName;
    /**
     * The CCNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCNo;
    /**
     * The CCYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCYear;
    /**
     * The CVV2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CVV2;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The DiscountedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscountedAmount;
    /**
     * The Host
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Host;
    /**
     * The MTLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MTLogId;
    /**
     * The MTVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MTVersion;
    /**
     * The MerchantCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantCode;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentId;
    /**
     * The ProdDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProdDesc;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The RefNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefNo;
    /**
     * The Referer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Referer;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Signature;
    /**
     * The SignatureType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignatureType;
    /**
     * The TerminalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalID;
    /**
     * The TokenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenId;
    /**
     * The UserContact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserContact;
    /**
     * The UserEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserEmail;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The forexRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $forexRate;
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lang;
    /**
     * The orderTerminalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderTerminalType;
    /**
     * The xfield1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xfield1;
    /**
     * The xfield2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xfield2;
    /**
     * Constructor method for ClientRequestModel
     * @uses ClientRequestModel::setActionType()
     * @uses ClientRequestModel::setAmount()
     * @uses ClientRequestModel::setBackendURL()
     * @uses ClientRequestModel::setBarcodeNo()
     * @uses ClientRequestModel::setCCCId()
     * @uses ClientRequestModel::setCCCOriTokenId()
     * @uses ClientRequestModel::setCCMonth()
     * @uses ClientRequestModel::setCCName()
     * @uses ClientRequestModel::setCCNo()
     * @uses ClientRequestModel::setCCYear()
     * @uses ClientRequestModel::setCVV2()
     * @uses ClientRequestModel::setCurrency()
     * @uses ClientRequestModel::setDiscountedAmount()
     * @uses ClientRequestModel::setHost()
     * @uses ClientRequestModel::setMTLogId()
     * @uses ClientRequestModel::setMTVersion()
     * @uses ClientRequestModel::setMerchantCode()
     * @uses ClientRequestModel::setPaymentId()
     * @uses ClientRequestModel::setProdDesc()
     * @uses ClientRequestModel::setPromoCode()
     * @uses ClientRequestModel::setRefNo()
     * @uses ClientRequestModel::setReferer()
     * @uses ClientRequestModel::setRemark()
     * @uses ClientRequestModel::setSignature()
     * @uses ClientRequestModel::setSignatureType()
     * @uses ClientRequestModel::setTerminalID()
     * @uses ClientRequestModel::setTokenId()
     * @uses ClientRequestModel::setUserContact()
     * @uses ClientRequestModel::setUserEmail()
     * @uses ClientRequestModel::setUserName()
     * @uses ClientRequestModel::setForexRate()
     * @uses ClientRequestModel::setLang()
     * @uses ClientRequestModel::setOrderTerminalType()
     * @uses ClientRequestModel::setXfield1()
     * @uses ClientRequestModel::setXfield2()
     * @param string $actionType
     * @param string $amount
     * @param string $backendURL
     * @param string $barcodeNo
     * @param string $cCCId
     * @param string $cCCOriTokenId
     * @param string $cCMonth
     * @param string $cCName
     * @param string $cCNo
     * @param string $cCYear
     * @param string $cVV2
     * @param string $currency
     * @param string $discountedAmount
     * @param string $host
     * @param string $mTLogId
     * @param string $mTVersion
     * @param string $merchantCode
     * @param int $paymentId
     * @param string $prodDesc
     * @param string $promoCode
     * @param string $refNo
     * @param string $referer
     * @param string $remark
     * @param string $signature
     * @param string $signatureType
     * @param string $terminalID
     * @param string $tokenId
     * @param string $userContact
     * @param string $userEmail
     * @param string $userName
     * @param string $forexRate
     * @param string $lang
     * @param string $orderTerminalType
     * @param string $xfield1
     * @param string $xfield2
     */
    public function __construct($actionType = null, $amount = null, $backendURL = null, $barcodeNo = null, $cCCId = null, $cCCOriTokenId = null, $cCMonth = null, $cCName = null, $cCNo = null, $cCYear = null, $cVV2 = null, $currency = null, $discountedAmount = null, $host = null, $mTLogId = null, $mTVersion = null, $merchantCode = null, $paymentId = null, $prodDesc = null, $promoCode = null, $refNo = null, $referer = null, $remark = null, $signature = null, $signatureType = null, $terminalID = null, $tokenId = null, $userContact = null, $userEmail = null, $userName = null, $forexRate = null, $lang = null, $orderTerminalType = null, $xfield1 = null, $xfield2 = null)
    {
        $this
            ->setActionType($actionType)
            ->setAmount($amount)
            ->setBackendURL($backendURL)
            ->setBarcodeNo($barcodeNo)
            ->setCCCId($cCCId)
            ->setCCCOriTokenId($cCCOriTokenId)
            ->setCCMonth($cCMonth)
            ->setCCName($cCName)
            ->setCCNo($cCNo)
            ->setCCYear($cCYear)
            ->setCVV2($cVV2)
            ->setCurrency($currency)
            ->setDiscountedAmount($discountedAmount)
            ->setHost($host)
            ->setMTLogId($mTLogId)
            ->setMTVersion($mTVersion)
            ->setMerchantCode($merchantCode)
            ->setPaymentId($paymentId)
            ->setProdDesc($prodDesc)
            ->setPromoCode($promoCode)
            ->setRefNo($refNo)
            ->setReferer($referer)
            ->setRemark($remark)
            ->setSignature($signature)
            ->setSignatureType($signatureType)
            ->setTerminalID($terminalID)
            ->setTokenId($tokenId)
            ->setUserContact($userContact)
            ->setUserEmail($userEmail)
            ->setUserName($userName)
            ->setForexRate($forexRate)
            ->setLang($lang)
            ->setOrderTerminalType($orderTerminalType)
            ->setXfield1($xfield1)
            ->setXfield2($xfield2);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionType
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amount
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BackendURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackendURL()
    {
        return isset($this->BackendURL) ? $this->BackendURL : null;
    }
    /**
     * Set BackendURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backendURL
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setBackendURL($backendURL = null)
    {
        // validation for constraint: string
        if (!is_null($backendURL) && !is_string($backendURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backendURL, true), gettype($backendURL)), __LINE__);
        }
        if (is_null($backendURL) || (is_array($backendURL) && empty($backendURL))) {
            unset($this->BackendURL);
        } else {
            $this->BackendURL = $backendURL;
        }
        return $this;
    }
    /**
     * Get BarcodeNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeNo()
    {
        return isset($this->BarcodeNo) ? $this->BarcodeNo : null;
    }
    /**
     * Set BarcodeNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeNo
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setBarcodeNo($barcodeNo = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNo) && !is_string($barcodeNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeNo, true), gettype($barcodeNo)), __LINE__);
        }
        if (is_null($barcodeNo) || (is_array($barcodeNo) && empty($barcodeNo))) {
            unset($this->BarcodeNo);
        } else {
            $this->BarcodeNo = $barcodeNo;
        }
        return $this;
    }
    /**
     * Get CCCId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCCId()
    {
        return isset($this->CCCId) ? $this->CCCId : null;
    }
    /**
     * Set CCCId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCCId
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCCId($cCCId = null)
    {
        // validation for constraint: string
        if (!is_null($cCCId) && !is_string($cCCId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCCId, true), gettype($cCCId)), __LINE__);
        }
        if (is_null($cCCId) || (is_array($cCCId) && empty($cCCId))) {
            unset($this->CCCId);
        } else {
            $this->CCCId = $cCCId;
        }
        return $this;
    }
    /**
     * Get CCCOriTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCCOriTokenId()
    {
        return isset($this->CCCOriTokenId) ? $this->CCCOriTokenId : null;
    }
    /**
     * Set CCCOriTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCCOriTokenId
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCCOriTokenId($cCCOriTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($cCCOriTokenId) && !is_string($cCCOriTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCCOriTokenId, true), gettype($cCCOriTokenId)), __LINE__);
        }
        if (is_null($cCCOriTokenId) || (is_array($cCCOriTokenId) && empty($cCCOriTokenId))) {
            unset($this->CCCOriTokenId);
        } else {
            $this->CCCOriTokenId = $cCCOriTokenId;
        }
        return $this;
    }
    /**
     * Get CCMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCMonth()
    {
        return isset($this->CCMonth) ? $this->CCMonth : null;
    }
    /**
     * Set CCMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCMonth
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCMonth($cCMonth = null)
    {
        // validation for constraint: string
        if (!is_null($cCMonth) && !is_string($cCMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCMonth, true), gettype($cCMonth)), __LINE__);
        }
        if (is_null($cCMonth) || (is_array($cCMonth) && empty($cCMonth))) {
            unset($this->CCMonth);
        } else {
            $this->CCMonth = $cCMonth;
        }
        return $this;
    }
    /**
     * Get CCName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCName()
    {
        return isset($this->CCName) ? $this->CCName : null;
    }
    /**
     * Set CCName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCName
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCName($cCName = null)
    {
        // validation for constraint: string
        if (!is_null($cCName) && !is_string($cCName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCName, true), gettype($cCName)), __LINE__);
        }
        if (is_null($cCName) || (is_array($cCName) && empty($cCName))) {
            unset($this->CCName);
        } else {
            $this->CCName = $cCName;
        }
        return $this;
    }
    /**
     * Get CCNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCNo()
    {
        return isset($this->CCNo) ? $this->CCNo : null;
    }
    /**
     * Set CCNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCNo
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCNo($cCNo = null)
    {
        // validation for constraint: string
        if (!is_null($cCNo) && !is_string($cCNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCNo, true), gettype($cCNo)), __LINE__);
        }
        if (is_null($cCNo) || (is_array($cCNo) && empty($cCNo))) {
            unset($this->CCNo);
        } else {
            $this->CCNo = $cCNo;
        }
        return $this;
    }
    /**
     * Get CCYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCYear()
    {
        return isset($this->CCYear) ? $this->CCYear : null;
    }
    /**
     * Set CCYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCYear
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCCYear($cCYear = null)
    {
        // validation for constraint: string
        if (!is_null($cCYear) && !is_string($cCYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCYear, true), gettype($cCYear)), __LINE__);
        }
        if (is_null($cCYear) || (is_array($cCYear) && empty($cCYear))) {
            unset($this->CCYear);
        } else {
            $this->CCYear = $cCYear;
        }
        return $this;
    }
    /**
     * Get CVV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCVV2()
    {
        return isset($this->CVV2) ? $this->CVV2 : null;
    }
    /**
     * Set CVV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cVV2
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCVV2($cVV2 = null)
    {
        // validation for constraint: string
        if (!is_null($cVV2) && !is_string($cVV2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV2, true), gettype($cVV2)), __LINE__);
        }
        if (is_null($cVV2) || (is_array($cVV2) && empty($cVV2))) {
            unset($this->CVV2);
        } else {
            $this->CVV2 = $cVV2;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get DiscountedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscountedAmount()
    {
        return isset($this->DiscountedAmount) ? $this->DiscountedAmount : null;
    }
    /**
     * Set DiscountedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discountedAmount
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setDiscountedAmount($discountedAmount = null)
    {
        // validation for constraint: string
        if (!is_null($discountedAmount) && !is_string($discountedAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountedAmount, true), gettype($discountedAmount)), __LINE__);
        }
        if (is_null($discountedAmount) || (is_array($discountedAmount) && empty($discountedAmount))) {
            unset($this->DiscountedAmount);
        } else {
            $this->DiscountedAmount = $discountedAmount;
        }
        return $this;
    }
    /**
     * Get Host value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHost()
    {
        return isset($this->Host) ? $this->Host : null;
    }
    /**
     * Set Host value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $host
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setHost($host = null)
    {
        // validation for constraint: string
        if (!is_null($host) && !is_string($host)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($host, true), gettype($host)), __LINE__);
        }
        if (is_null($host) || (is_array($host) && empty($host))) {
            unset($this->Host);
        } else {
            $this->Host = $host;
        }
        return $this;
    }
    /**
     * Get MTLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMTLogId()
    {
        return isset($this->MTLogId) ? $this->MTLogId : null;
    }
    /**
     * Set MTLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mTLogId
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setMTLogId($mTLogId = null)
    {
        // validation for constraint: string
        if (!is_null($mTLogId) && !is_string($mTLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mTLogId, true), gettype($mTLogId)), __LINE__);
        }
        if (is_null($mTLogId) || (is_array($mTLogId) && empty($mTLogId))) {
            unset($this->MTLogId);
        } else {
            $this->MTLogId = $mTLogId;
        }
        return $this;
    }
    /**
     * Get MTVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMTVersion()
    {
        return isset($this->MTVersion) ? $this->MTVersion : null;
    }
    /**
     * Set MTVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mTVersion
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setMTVersion($mTVersion = null)
    {
        // validation for constraint: string
        if (!is_null($mTVersion) && !is_string($mTVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mTVersion, true), gettype($mTVersion)), __LINE__);
        }
        if (is_null($mTVersion) || (is_array($mTVersion) && empty($mTVersion))) {
            unset($this->MTVersion);
        } else {
            $this->MTVersion = $mTVersion;
        }
        return $this;
    }
    /**
     * Get MerchantCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantCode()
    {
        return isset($this->MerchantCode) ? $this->MerchantCode : null;
    }
    /**
     * Set MerchantCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantCode
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setMerchantCode($merchantCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantCode) && !is_string($merchantCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantCode, true), gettype($merchantCode)), __LINE__);
        }
        if (is_null($merchantCode) || (is_array($merchantCode) && empty($merchantCode))) {
            unset($this->MerchantCode);
        } else {
            $this->MerchantCode = $merchantCode;
        }
        return $this;
    }
    /**
     * Get PaymentId value
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param int $paymentId
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !(is_int($paymentId) || ctype_digit($paymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get ProdDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProdDesc()
    {
        return isset($this->ProdDesc) ? $this->ProdDesc : null;
    }
    /**
     * Set ProdDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prodDesc
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setProdDesc($prodDesc = null)
    {
        // validation for constraint: string
        if (!is_null($prodDesc) && !is_string($prodDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prodDesc, true), gettype($prodDesc)), __LINE__);
        }
        if (is_null($prodDesc) || (is_array($prodDesc) && empty($prodDesc))) {
            unset($this->ProdDesc);
        } else {
            $this->ProdDesc = $prodDesc;
        }
        return $this;
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get RefNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefNo()
    {
        return isset($this->RefNo) ? $this->RefNo : null;
    }
    /**
     * Set RefNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refNo
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setRefNo($refNo = null)
    {
        // validation for constraint: string
        if (!is_null($refNo) && !is_string($refNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNo, true), gettype($refNo)), __LINE__);
        }
        if (is_null($refNo) || (is_array($refNo) && empty($refNo))) {
            unset($this->RefNo);
        } else {
            $this->RefNo = $refNo;
        }
        return $this;
    }
    /**
     * Get Referer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferer()
    {
        return isset($this->Referer) ? $this->Referer : null;
    }
    /**
     * Set Referer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referer
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setReferer($referer = null)
    {
        // validation for constraint: string
        if (!is_null($referer) && !is_string($referer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referer, true), gettype($referer)), __LINE__);
        }
        if (is_null($referer) || (is_array($referer) && empty($referer))) {
            unset($this->Referer);
        } else {
            $this->Referer = $referer;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get Signature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignature()
    {
        return isset($this->Signature) ? $this->Signature : null;
    }
    /**
     * Set Signature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signature
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        if (is_null($signature) || (is_array($signature) && empty($signature))) {
            unset($this->Signature);
        } else {
            $this->Signature = $signature;
        }
        return $this;
    }
    /**
     * Get SignatureType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignatureType()
    {
        return isset($this->SignatureType) ? $this->SignatureType : null;
    }
    /**
     * Set SignatureType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signatureType
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setSignatureType($signatureType = null)
    {
        // validation for constraint: string
        if (!is_null($signatureType) && !is_string($signatureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureType, true), gettype($signatureType)), __LINE__);
        }
        if (is_null($signatureType) || (is_array($signatureType) && empty($signatureType))) {
            unset($this->SignatureType);
        } else {
            $this->SignatureType = $signatureType;
        }
        return $this;
    }
    /**
     * Get TerminalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalID()
    {
        return isset($this->TerminalID) ? $this->TerminalID : null;
    }
    /**
     * Set TerminalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalID
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: string
        if (!is_null($terminalID) && !is_string($terminalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        if (is_null($terminalID) || (is_array($terminalID) && empty($terminalID))) {
            unset($this->TerminalID);
        } else {
            $this->TerminalID = $terminalID;
        }
        return $this;
    }
    /**
     * Get TokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenId()
    {
        return isset($this->TokenId) ? $this->TokenId : null;
    }
    /**
     * Set TokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenId
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        if (is_null($tokenId) || (is_array($tokenId) && empty($tokenId))) {
            unset($this->TokenId);
        } else {
            $this->TokenId = $tokenId;
        }
        return $this;
    }
    /**
     * Get UserContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserContact()
    {
        return isset($this->UserContact) ? $this->UserContact : null;
    }
    /**
     * Set UserContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userContact
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setUserContact($userContact = null)
    {
        // validation for constraint: string
        if (!is_null($userContact) && !is_string($userContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userContact, true), gettype($userContact)), __LINE__);
        }
        if (is_null($userContact) || (is_array($userContact) && empty($userContact))) {
            unset($this->UserContact);
        } else {
            $this->UserContact = $userContact;
        }
        return $this;
    }
    /**
     * Get UserEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserEmail()
    {
        return isset($this->UserEmail) ? $this->UserEmail : null;
    }
    /**
     * Set UserEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userEmail
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setUserEmail($userEmail = null)
    {
        // validation for constraint: string
        if (!is_null($userEmail) && !is_string($userEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userEmail, true), gettype($userEmail)), __LINE__);
        }
        if (is_null($userEmail) || (is_array($userEmail) && empty($userEmail))) {
            unset($this->UserEmail);
        } else {
            $this->UserEmail = $userEmail;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get forexRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForexRate()
    {
        return isset($this->forexRate) ? $this->forexRate : null;
    }
    /**
     * Set forexRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forexRate
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setForexRate($forexRate = null)
    {
        // validation for constraint: string
        if (!is_null($forexRate) && !is_string($forexRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forexRate, true), gettype($forexRate)), __LINE__);
        }
        if (is_null($forexRate) || (is_array($forexRate) && empty($forexRate))) {
            unset($this->forexRate);
        } else {
            $this->forexRate = $forexRate;
        }
        return $this;
    }
    /**
     * Get lang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLang()
    {
        return isset($this->lang) ? $this->lang : null;
    }
    /**
     * Set lang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lang
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        if (is_null($lang) || (is_array($lang) && empty($lang))) {
            unset($this->lang);
        } else {
            $this->lang = $lang;
        }
        return $this;
    }
    /**
     * Get orderTerminalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderTerminalType()
    {
        return isset($this->orderTerminalType) ? $this->orderTerminalType : null;
    }
    /**
     * Set orderTerminalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderTerminalType
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setOrderTerminalType($orderTerminalType = null)
    {
        // validation for constraint: string
        if (!is_null($orderTerminalType) && !is_string($orderTerminalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderTerminalType, true), gettype($orderTerminalType)), __LINE__);
        }
        if (is_null($orderTerminalType) || (is_array($orderTerminalType) && empty($orderTerminalType))) {
            unset($this->orderTerminalType);
        } else {
            $this->orderTerminalType = $orderTerminalType;
        }
        return $this;
    }
    /**
     * Get xfield1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXfield1()
    {
        return isset($this->xfield1) ? $this->xfield1 : null;
    }
    /**
     * Set xfield1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xfield1
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setXfield1($xfield1 = null)
    {
        // validation for constraint: string
        if (!is_null($xfield1) && !is_string($xfield1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xfield1, true), gettype($xfield1)), __LINE__);
        }
        if (is_null($xfield1) || (is_array($xfield1) && empty($xfield1))) {
            unset($this->xfield1);
        } else {
            $this->xfield1 = $xfield1;
        }
        return $this;
    }
    /**
     * Get xfield2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXfield2()
    {
        return isset($this->xfield2) ? $this->xfield2 : null;
    }
    /**
     * Set xfield2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xfield2
     * @return \Frontdesk\StructType\ClientRequestModel
     */
    public function setXfield2($xfield2 = null)
    {
        // validation for constraint: string
        if (!is_null($xfield2) && !is_string($xfield2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xfield2, true), gettype($xfield2)), __LINE__);
        }
        if (is_null($xfield2) || (is_array($xfield2) && empty($xfield2))) {
            unset($this->xfield2);
        } else {
            $this->xfield2 = $xfield2;
        }
        return $this;
    }
}
