<?php

namespace Frontdesk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Exception StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Exception
 * @subpackage Structs
 */
class Exception extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The FactoryType
     * Meta information extracted from the WSDL
     * - ref: ser:FactoryType
     * @var string
     */
    public $FactoryType;
    /**
     * Constructor method for Exception
     * @uses Exception::setAny()
     * @uses Exception::setFactoryType()
     * @param \DOMDocument $any
     * @param string $factoryType
     */
    public function __construct(\DOMDocument $any = null, $factoryType = null)
    {
        $this
            ->setAny($any)
            ->setFactoryType($factoryType);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Frontdesk\StructType\Exception
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get FactoryType value
     * @return string|null
     */
    public function getFactoryType()
    {
        return $this->FactoryType;
    }
    /**
     * Set FactoryType value
     * @param string $factoryType
     * @return \Frontdesk\StructType\Exception
     */
    public function setFactoryType($factoryType = null)
    {
        // validation for constraint: string
        if (!is_null($factoryType) && !is_string($factoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factoryType, true), gettype($factoryType)), __LINE__);
        }
        $this->FactoryType = $factoryType;
        return $this;
    }
}
