<?php

namespace Frontdesk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Entry ServiceType
 * @subpackage Services
 */
class Entry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EntryPageFunctionality
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Frontdesk\StructType\EntryPageFunctionality $parameters
     * @return \Frontdesk\StructType\EntryPageFunctionalityResponse|bool
     */
    public function EntryPageFunctionality(\Frontdesk\StructType\EntryPageFunctionality $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntryPageFunctionality($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntryPageFunctionalityV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Frontdesk\StructType\EntryPageFunctionalityV2 $parameters
     * @return \Frontdesk\StructType\EntryPageFunctionalityV2Response|bool
     */
    public function EntryPageFunctionalityV2(\Frontdesk\StructType\EntryPageFunctionalityV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntryPageFunctionalityV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Frontdesk\StructType\EntryPageFunctionalityResponse|\Frontdesk\StructType\EntryPageFunctionalityV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
