<?php

namespace farpointsystems\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ping ServiceType
 * @subpackage Services
 */
class Ping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Ping
     * Meta information extracted from the WSDL
     * - documentation: Ping - Ping the service to see if it is activePing Text as providedPing Text
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\StructType\Ping $parameters
     * @return \farpointsystems\StructType\PingResponse|bool
     */
    public function Ping(\farpointsystems\StructType\Ping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Ping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \farpointsystems\StructType\PingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
