<?php

namespace farpointsystems\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxReturnResponseType StructType
 * @subpackage Structs
 */
class TaxReturnResponseType extends AbstractStructBase
{
    /**
     * The FilingPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FilingPeriod;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The UsageType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $UsageType;
    /**
     * The SubmissionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubmissionID;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The ValidatingVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidatingVersion;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \farpointsystems\StructType\ErrorGroupType
     */
    public $Errors;
    /**
     * The SystemErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemErrorMessage;
    /**
     * Constructor method for TaxReturnResponseType
     * @uses TaxReturnResponseType::setFilingPeriod()
     * @uses TaxReturnResponseType::setSuccess()
     * @uses TaxReturnResponseType::setUsageType()
     * @uses TaxReturnResponseType::setSubmissionID()
     * @uses TaxReturnResponseType::setConfirmationNumber()
     * @uses TaxReturnResponseType::setValidatingVersion()
     * @uses TaxReturnResponseType::setAccountNumber()
     * @uses TaxReturnResponseType::setMessage()
     * @uses TaxReturnResponseType::setErrors()
     * @uses TaxReturnResponseType::setSystemErrorMessage()
     * @param string $filingPeriod
     * @param bool $success
     * @param string $usageType
     * @param string $submissionID
     * @param string $confirmationNumber
     * @param string $validatingVersion
     * @param string $accountNumber
     * @param string $message
     * @param \farpointsystems\StructType\ErrorGroupType $errors
     * @param string $systemErrorMessage
     */
    public function __construct($filingPeriod = null, $success = null, $usageType = null, $submissionID = null, $confirmationNumber = null, $validatingVersion = null, $accountNumber = null, $message = null, \farpointsystems\StructType\ErrorGroupType $errors = null, $systemErrorMessage = null)
    {
        $this
            ->setFilingPeriod($filingPeriod)
            ->setSuccess($success)
            ->setUsageType($usageType)
            ->setSubmissionID($submissionID)
            ->setConfirmationNumber($confirmationNumber)
            ->setValidatingVersion($validatingVersion)
            ->setAccountNumber($accountNumber)
            ->setMessage($message)
            ->setErrors($errors)
            ->setSystemErrorMessage($systemErrorMessage);
    }
    /**
     * Get FilingPeriod value
     * @return string
     */
    public function getFilingPeriod()
    {
        return $this->FilingPeriod;
    }
    /**
     * Set FilingPeriod value
     * @param string $filingPeriod
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setFilingPeriod($filingPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($filingPeriod) && !is_string($filingPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filingPeriod, true), gettype($filingPeriod)), __LINE__);
        }
        $this->FilingPeriod = $filingPeriod;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get UsageType value
     * @return string
     */
    public function getUsageType()
    {
        return $this->UsageType;
    }
    /**
     * Set UsageType value
     * @uses \farpointsystems\EnumType\UsageType::valueIsValid()
     * @uses \farpointsystems\EnumType\UsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usageType
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setUsageType($usageType = null)
    {
        // validation for constraint: enumeration
        if (!\farpointsystems\EnumType\UsageType::valueIsValid($usageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \farpointsystems\EnumType\UsageType', is_array($usageType) ? implode(', ', $usageType) : var_export($usageType, true), implode(', ', \farpointsystems\EnumType\UsageType::getValidValues())), __LINE__);
        }
        $this->UsageType = $usageType;
        return $this;
    }
    /**
     * Get SubmissionID value
     * @return string|null
     */
    public function getSubmissionID()
    {
        return $this->SubmissionID;
    }
    /**
     * Set SubmissionID value
     * @param string $submissionID
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setSubmissionID($submissionID = null)
    {
        // validation for constraint: string
        if (!is_null($submissionID) && !is_string($submissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submissionID, true), gettype($submissionID)), __LINE__);
        }
        $this->SubmissionID = $submissionID;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get ValidatingVersion value
     * @return string|null
     */
    public function getValidatingVersion()
    {
        return $this->ValidatingVersion;
    }
    /**
     * Set ValidatingVersion value
     * @param string $validatingVersion
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setValidatingVersion($validatingVersion = null)
    {
        // validation for constraint: string
        if (!is_null($validatingVersion) && !is_string($validatingVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingVersion, true), gettype($validatingVersion)), __LINE__);
        }
        $this->ValidatingVersion = $validatingVersion;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Errors value
     * @return \farpointsystems\StructType\ErrorGroupType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \farpointsystems\StructType\ErrorGroupType $errors
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setErrors(\farpointsystems\StructType\ErrorGroupType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get SystemErrorMessage value
     * @return string|null
     */
    public function getSystemErrorMessage()
    {
        return $this->SystemErrorMessage;
    }
    /**
     * Set SystemErrorMessage value
     * @param string $systemErrorMessage
     * @return \farpointsystems\StructType\TaxReturnResponseType
     */
    public function setSystemErrorMessage($systemErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($systemErrorMessage) && !is_string($systemErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemErrorMessage, true), gettype($systemErrorMessage)), __LINE__);
        }
        $this->SystemErrorMessage = $systemErrorMessage;
        return $this;
    }
}
