<?php

namespace farpointsystems\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Make ServiceType
 * @subpackage Services
 */
class Make extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named makePrePayment
     * Meta information extracted from the WSDL
     * - documentation: makePrePayment - Make a prepayment to the CDTFAResponse data for making a prepaymentPrepayment Request HeaderPrepayment data, as XML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\StructType\MakePrePayment $parameters
     * @return \farpointsystems\StructType\MakePrePaymentResponse|bool
     */
    public function makePrePayment(\farpointsystems\StructType\MakePrePayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->makePrePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \farpointsystems\StructType\MakePrePaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
