<?php

namespace farpointsystems\cdtfa-test\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ping ServiceType
 * @subpackage Services
 */
class Ping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Ping
     * Meta information extracted from the WSDL
     * - documentation: Ping - Ping the service to see if it is activePing Text as providedPing Text
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\cdtfa-test\StructType\Ping $parameters
     * @return \farpointsystems\cdtfa-test\StructType\PingResponse|bool
     */
    public function Ping(\farpointsystems\cdtfa-test\StructType\Ping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Ping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \farpointsystems\cdtfa-test\StructType\PingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
