<?php

namespace farpointsystems\cdtfa-test\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fileTaxReturn StructType
 * @subpackage Structs
 */
class FileTaxReturn extends AbstractStructBase
{
    /**
     * The RequestHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \farpointsystems\cdtfa-test\StructType\RequestHeaderType
     */
    public $RequestHeader;
    /**
     * The TaxReturnData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxReturnData;
    /**
     * Constructor method for fileTaxReturn
     * @uses FileTaxReturn::setRequestHeader()
     * @uses FileTaxReturn::setTaxReturnData()
     * @param \farpointsystems\cdtfa-test\StructType\RequestHeaderType $requestHeader
     * @param string $taxReturnData
     */
    public function __construct(\farpointsystems\cdtfa-test\StructType\RequestHeaderType $requestHeader = null, $taxReturnData = null)
    {
        $this
            ->setRequestHeader($requestHeader)
            ->setTaxReturnData($taxReturnData);
    }
    /**
     * Get RequestHeader value
     * @return \farpointsystems\cdtfa-test\StructType\RequestHeaderType
     */
    public function getRequestHeader()
    {
        return $this->RequestHeader;
    }
    /**
     * Set RequestHeader value
     * @param \farpointsystems\cdtfa-test\StructType\RequestHeaderType $requestHeader
     * @return \farpointsystems\cdtfa-test\StructType\FileTaxReturn
     */
    public function setRequestHeader(\farpointsystems\cdtfa-test\StructType\RequestHeaderType $requestHeader = null)
    {
        $this->RequestHeader = $requestHeader;
        return $this;
    }
    /**
     * Get TaxReturnData value
     * @return string
     */
    public function getTaxReturnData()
    {
        return $this->TaxReturnData;
    }
    /**
     * Set TaxReturnData value
     * @param string $taxReturnData
     * @return \farpointsystems\cdtfa-test\StructType\FileTaxReturn
     */
    public function setTaxReturnData($taxReturnData = null)
    {
        // validation for constraint: string
        if (!is_null($taxReturnData) && !is_string($taxReturnData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxReturnData, true), gettype($taxReturnData)), __LINE__);
        }
        $this->TaxReturnData = $taxReturnData;
        return $this;
    }
}
