<?php

namespace farpointsystems\cdtfa-test\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSUTPrepayFuelRates
     * Meta information extracted from the WSDL
     * - documentation: getSUTPrepayFuelRates - Retrieve a list of prepayment fuel ratesResponse data for motor fuel ratesPeriod End Date
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\cdtfa-test\StructType\GetSUTPrepayFuelRates $parameters
     * @return \farpointsystems\cdtfa-test\StructType\GetSUTPrepayFuelRatesResponse|bool
     */
    public function getSUTPrepayFuelRates(\farpointsystems\cdtfa-test\StructType\GetSUTPrepayFuelRates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSUTPrepayFuelRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubLocations
     * Meta information extracted from the WSDL
     * - documentation: getSubLocations - Retrieve a list of sub locations registered with the CDTFAResponse data for listing of sub locationsAccount NumberPeriod Begin DatePeriod End Date
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\cdtfa-test\StructType\GetSubLocations $parameters
     * @return \farpointsystems\cdtfa-test\StructType\GetSubLocationsResponse|bool
     */
    public function getSubLocations(\farpointsystems\cdtfa-test\StructType\GetSubLocations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSubLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReturnPackage
     * Meta information extracted from the WSDL
     * - documentation: getFilingPeriod - Retrieve information about a period of an account registered with the CDTFAResponse data for filing period informationAccount Number
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \farpointsystems\cdtfa-test\StructType\GetReturnPackage $parameters
     * @return \farpointsystems\cdtfa-test\StructType\GetReturnPackageResponse|bool
     */
    public function getReturnPackage(\farpointsystems\cdtfa-test\StructType\GetReturnPackage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReturnPackage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \farpointsystems\cdtfa-test\StructType\GetReturnPackageResponse|\farpointsystems\cdtfa-test\StructType\GetSubLocationsResponse|\farpointsystems\cdtfa-test\StructType\GetSUTPrepayFuelRatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
