<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \farpointsystems\cdtfa-test\ClassMap::get(),
);
/**
 * Samples for File ServiceType
 */
$file = new \farpointsystems\cdtfa-test\ServiceType\File($options);
/**
 * Sample call for fileTaxReturn operation/method
 */
if ($file->fileTaxReturn(new \farpointsystems\cdtfa-test\StructType\FileTaxReturn()) !== false) {
    print_r($file->getResult());
} else {
    print_r($file->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \farpointsystems\cdtfa-test\ServiceType\Get($options);
/**
 * Sample call for getSUTPrepayFuelRates operation/method
 */
if ($get->getSUTPrepayFuelRates(new \farpointsystems\cdtfa-test\StructType\GetSUTPrepayFuelRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubLocations operation/method
 */
if ($get->getSubLocations(new \farpointsystems\cdtfa-test\StructType\GetSubLocations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReturnPackage operation/method
 */
if ($get->getReturnPackage(new \farpointsystems\cdtfa-test\StructType\GetReturnPackage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \farpointsystems\cdtfa-test\ServiceType\Make($options);
/**
 * Sample call for makePrePayment operation/method
 */
if ($make->makePrePayment(new \farpointsystems\cdtfa-test\StructType\MakePrePayment()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \farpointsystems\cdtfa-test\ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \farpointsystems\cdtfa-test\StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
