<?php

namespace farpointsystems\cdtfa-test\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingLocationType StructType
 * @subpackage Structs
 */
class ExistingLocationType extends AbstractStructBase
{
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The LocationAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \farpointsystems\cdtfa-test\StructType\RequiredAddressType
     */
    public $LocationAddress;
    /**
     * The LocationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationNumber;
    /**
     * The TaxAreaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \farpointsystems\cdtfa-test\StructType\TaxAreaCodeType
     */
    public $TaxAreaCode;
    /**
     * Constructor method for ExistingLocationType
     * @uses ExistingLocationType::setLocationName()
     * @uses ExistingLocationType::setLocationAddress()
     * @uses ExistingLocationType::setLocationNumber()
     * @uses ExistingLocationType::setTaxAreaCode()
     * @param string $locationName
     * @param \farpointsystems\cdtfa-test\StructType\RequiredAddressType $locationAddress
     * @param string $locationNumber
     * @param \farpointsystems\cdtfa-test\StructType\TaxAreaCodeType $taxAreaCode
     */
    public function __construct($locationName = null, \farpointsystems\cdtfa-test\StructType\RequiredAddressType $locationAddress = null, $locationNumber = null, \farpointsystems\cdtfa-test\StructType\TaxAreaCodeType $taxAreaCode = null)
    {
        $this
            ->setLocationName($locationName)
            ->setLocationAddress($locationAddress)
            ->setLocationNumber($locationNumber)
            ->setTaxAreaCode($taxAreaCode);
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \farpointsystems\cdtfa-test\StructType\ExistingLocationType
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get LocationAddress value
     * @return \farpointsystems\cdtfa-test\StructType\RequiredAddressType|null
     */
    public function getLocationAddress()
    {
        return $this->LocationAddress;
    }
    /**
     * Set LocationAddress value
     * @param \farpointsystems\cdtfa-test\StructType\RequiredAddressType $locationAddress
     * @return \farpointsystems\cdtfa-test\StructType\ExistingLocationType
     */
    public function setLocationAddress(\farpointsystems\cdtfa-test\StructType\RequiredAddressType $locationAddress = null)
    {
        $this->LocationAddress = $locationAddress;
        return $this;
    }
    /**
     * Get LocationNumber value
     * @return string|null
     */
    public function getLocationNumber()
    {
        return $this->LocationNumber;
    }
    /**
     * Set LocationNumber value
     * @param string $locationNumber
     * @return \farpointsystems\cdtfa-test\StructType\ExistingLocationType
     */
    public function setLocationNumber($locationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($locationNumber) && !is_string($locationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationNumber, true), gettype($locationNumber)), __LINE__);
        }
        $this->LocationNumber = $locationNumber;
        return $this;
    }
    /**
     * Get TaxAreaCode value
     * @return \farpointsystems\cdtfa-test\StructType\TaxAreaCodeType|null
     */
    public function getTaxAreaCode()
    {
        return $this->TaxAreaCode;
    }
    /**
     * Set TaxAreaCode value
     * @param \farpointsystems\cdtfa-test\StructType\TaxAreaCodeType $taxAreaCode
     * @return \farpointsystems\cdtfa-test\StructType\ExistingLocationType
     */
    public function setTaxAreaCode(\farpointsystems\cdtfa-test\StructType\TaxAreaCodeType $taxAreaCode = null)
    {
        $this->TaxAreaCode = $taxAreaCode;
        return $this;
    }
}
