<?php

namespace farpointsystems\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubLocationResponseType StructType
 * @subpackage Structs
 */
class SubLocationResponseType extends AbstractStructBase
{
    /**
     * The NumberOfSubLocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfSubLocations;
    /**
     * The SubOutletInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \farpointsystems\StructType\ExistingLocationType[]
     */
    public $SubOutletInformation;
    /**
     * Constructor method for SubLocationResponseType
     * @uses SubLocationResponseType::setNumberOfSubLocations()
     * @uses SubLocationResponseType::setSubOutletInformation()
     * @param int $numberOfSubLocations
     * @param \farpointsystems\StructType\ExistingLocationType[] $subOutletInformation
     */
    public function __construct($numberOfSubLocations = null, array $subOutletInformation = array())
    {
        $this
            ->setNumberOfSubLocations($numberOfSubLocations)
            ->setSubOutletInformation($subOutletInformation);
    }
    /**
     * Get NumberOfSubLocations value
     * @return int
     */
    public function getNumberOfSubLocations()
    {
        return $this->NumberOfSubLocations;
    }
    /**
     * Set NumberOfSubLocations value
     * @param int $numberOfSubLocations
     * @return \farpointsystems\StructType\SubLocationResponseType
     */
    public function setNumberOfSubLocations($numberOfSubLocations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSubLocations) && !(is_int($numberOfSubLocations) || ctype_digit($numberOfSubLocations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSubLocations, true), gettype($numberOfSubLocations)), __LINE__);
        }
        $this->NumberOfSubLocations = $numberOfSubLocations;
        return $this;
    }
    /**
     * Get SubOutletInformation value
     * @return \farpointsystems\StructType\ExistingLocationType[]|null
     */
    public function getSubOutletInformation()
    {
        return $this->SubOutletInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setSubOutletInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubOutletInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubOutletInformationForArrayConstraintsFromSetSubOutletInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subLocationResponseTypeSubOutletInformationItem) {
            // validation for constraint: itemType
            if (!$subLocationResponseTypeSubOutletInformationItem instanceof \farpointsystems\StructType\ExistingLocationType) {
                $invalidValues[] = is_object($subLocationResponseTypeSubOutletInformationItem) ? get_class($subLocationResponseTypeSubOutletInformationItem) : sprintf('%s(%s)', gettype($subLocationResponseTypeSubOutletInformationItem), var_export($subLocationResponseTypeSubOutletInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubOutletInformation property can only contain items of type \farpointsystems\StructType\ExistingLocationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubOutletInformation value
     * @throws \InvalidArgumentException
     * @param \farpointsystems\StructType\ExistingLocationType[] $subOutletInformation
     * @return \farpointsystems\StructType\SubLocationResponseType
     */
    public function setSubOutletInformation(array $subOutletInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($subOutletInformationArrayErrorMessage = self::validateSubOutletInformationForArrayConstraintsFromSetSubOutletInformation($subOutletInformation))) {
            throw new \InvalidArgumentException($subOutletInformationArrayErrorMessage, __LINE__);
        }
        $this->SubOutletInformation = $subOutletInformation;
        return $this;
    }
    /**
     * Add item to SubOutletInformation value
     * @throws \InvalidArgumentException
     * @param \farpointsystems\StructType\ExistingLocationType $item
     * @return \farpointsystems\StructType\SubLocationResponseType
     */
    public function addToSubOutletInformation(\farpointsystems\StructType\ExistingLocationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \farpointsystems\StructType\ExistingLocationType) {
            throw new \InvalidArgumentException(sprintf('The SubOutletInformation property can only contain items of type \farpointsystems\StructType\ExistingLocationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubOutletInformation[] = $item;
        return $this;
    }
}
