<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \TomVaughan\ClassMap::get(),
);
/**
 * Samples for File ServiceType
 */
$file = new \TomVaughan\ServiceType\File($options);
/**
 * Sample call for fileTaxReturn operation/method
 */
if ($file->fileTaxReturn(new \TomVaughan\StructType\FileTaxReturn()) !== false) {
    print_r($file->getResult());
} else {
    print_r($file->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \TomVaughan\ServiceType\Get($options);
/**
 * Sample call for getSUTPrepayFuelRates operation/method
 */
if ($get->getSUTPrepayFuelRates(new \TomVaughan\StructType\GetSUTPrepayFuelRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubLocations operation/method
 */
if ($get->getSubLocations(new \TomVaughan\StructType\GetSubLocations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReturnPackage operation/method
 */
if ($get->getReturnPackage(new \TomVaughan\StructType\GetReturnPackage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \TomVaughan\ServiceType\Make($options);
/**
 * Sample call for makePrePayment operation/method
 */
if ($make->makePrePayment(new \TomVaughan\StructType\MakePrePayment()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \TomVaughan\ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \TomVaughan\StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
