<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPackageFormType StructType
 * @subpackage Structs
 */
class ReturnPackageFormType extends AbstractStructBase
{
    /**
     * The FormType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FormType;
    /**
     * Constructor method for ReturnPackageFormType
     * @uses ReturnPackageFormType::setFormType()
     * @param string[] $formType
     */
    public function __construct(array $formType = array())
    {
        $this
            ->setFormType($formType);
    }
    /**
     * Get FormType value
     * @return string[]|null
     */
    public function getFormType()
    {
        return $this->FormType;
    }
    /**
     * This method is responsible for validating the values passed to the setFormType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormTypeForArrayConstraintsFromSetFormType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnPackageFormTypeFormTypeItem) {
            // validation for constraint: enumeration
            if (!\TomVaughan\EnumType\FormType::valueIsValid($returnPackageFormTypeFormTypeItem)) {
                $invalidValues[] = is_object($returnPackageFormTypeFormTypeItem) ? get_class($returnPackageFormTypeFormTypeItem) : sprintf('%s(%s)', gettype($returnPackageFormTypeFormTypeItem), var_export($returnPackageFormTypeFormTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TomVaughan\EnumType\FormType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \TomVaughan\EnumType\FormType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FormType value
     * @uses \TomVaughan\EnumType\FormType::valueIsValid()
     * @uses \TomVaughan\EnumType\FormType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $formType
     * @return \TomVaughan\StructType\ReturnPackageFormType
     */
    public function setFormType(array $formType = array())
    {
        // validation for constraint: array
        if ('' !== ($formTypeArrayErrorMessage = self::validateFormTypeForArrayConstraintsFromSetFormType($formType))) {
            throw new \InvalidArgumentException($formTypeArrayErrorMessage, __LINE__);
        }
        $this->FormType = $formType;
        return $this;
    }
    /**
     * Add item to FormType value
     * @uses \TomVaughan\EnumType\FormType::valueIsValid()
     * @uses \TomVaughan\EnumType\FormType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \TomVaughan\StructType\ReturnPackageFormType
     */
    public function addToFormType($item)
    {
        // validation for constraint: enumeration
        if (!\TomVaughan\EnumType\FormType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TomVaughan\EnumType\FormType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \TomVaughan\EnumType\FormType::getValidValues())), __LINE__);
        }
        $this->FormType[] = $item;
        return $this;
    }
}
