<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingLocationType StructType
 * @subpackage Structs
 */
class ExistingLocationType extends AbstractStructBase
{
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The LocationAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TomVaughan\StructType\RequiredAddressType
     */
    public $LocationAddress;
    /**
     * The LocationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationNumber;
    /**
     * The TaxAreaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TomVaughan\StructType\TaxAreaCodeType
     */
    public $TaxAreaCode;
    /**
     * Constructor method for ExistingLocationType
     * @uses ExistingLocationType::setLocationName()
     * @uses ExistingLocationType::setLocationAddress()
     * @uses ExistingLocationType::setLocationNumber()
     * @uses ExistingLocationType::setTaxAreaCode()
     * @param string $locationName
     * @param \TomVaughan\StructType\RequiredAddressType $locationAddress
     * @param string $locationNumber
     * @param \TomVaughan\StructType\TaxAreaCodeType $taxAreaCode
     */
    public function __construct($locationName = null, \TomVaughan\StructType\RequiredAddressType $locationAddress = null, $locationNumber = null, \TomVaughan\StructType\TaxAreaCodeType $taxAreaCode = null)
    {
        $this
            ->setLocationName($locationName)
            ->setLocationAddress($locationAddress)
            ->setLocationNumber($locationNumber)
            ->setTaxAreaCode($taxAreaCode);
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \TomVaughan\StructType\ExistingLocationType
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get LocationAddress value
     * @return \TomVaughan\StructType\RequiredAddressType|null
     */
    public function getLocationAddress()
    {
        return $this->LocationAddress;
    }
    /**
     * Set LocationAddress value
     * @param \TomVaughan\StructType\RequiredAddressType $locationAddress
     * @return \TomVaughan\StructType\ExistingLocationType
     */
    public function setLocationAddress(\TomVaughan\StructType\RequiredAddressType $locationAddress = null)
    {
        $this->LocationAddress = $locationAddress;
        return $this;
    }
    /**
     * Get LocationNumber value
     * @return string|null
     */
    public function getLocationNumber()
    {
        return $this->LocationNumber;
    }
    /**
     * Set LocationNumber value
     * @param string $locationNumber
     * @return \TomVaughan\StructType\ExistingLocationType
     */
    public function setLocationNumber($locationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($locationNumber) && !is_string($locationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationNumber, true), gettype($locationNumber)), __LINE__);
        }
        $this->LocationNumber = $locationNumber;
        return $this;
    }
    /**
     * Get TaxAreaCode value
     * @return \TomVaughan\StructType\TaxAreaCodeType|null
     */
    public function getTaxAreaCode()
    {
        return $this->TaxAreaCode;
    }
    /**
     * Set TaxAreaCode value
     * @param \TomVaughan\StructType\TaxAreaCodeType $taxAreaCode
     * @return \TomVaughan\StructType\ExistingLocationType
     */
    public function setTaxAreaCode(\TomVaughan\StructType\TaxAreaCodeType $taxAreaCode = null)
    {
        $this->TaxAreaCode = $taxAreaCode;
        return $this;
    }
}
