<?php

namespace TomVaughan\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for File ServiceType
 * @subpackage Services
 */
class File extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named fileTaxReturn
     * Meta information extracted from the WSDL
     * - documentation: fileTaxReturn - File a tax return with the CDTFAResponse data for tax return filingFiling Request HeaderTax return, as XML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TomVaughan\StructType\FileTaxReturn $parameters
     * @return \TomVaughan\StructType\FileTaxReturnResponse|bool
     */
    public function fileTaxReturn(\TomVaughan\StructType\FileTaxReturn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->fileTaxReturn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TomVaughan\StructType\FileTaxReturnResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
