<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxAreaCodeType StructType
 * @subpackage Structs
 */
class TaxAreaCodeType extends AbstractStructBase
{
    /**
     * The CountyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyCode;
    /**
     * The LocalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalCode;
    /**
     * The DistrictCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistrictCode;
    /**
     * The InlieuCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InlieuCode;
    /**
     * Constructor method for TaxAreaCodeType
     * @uses TaxAreaCodeType::setCountyCode()
     * @uses TaxAreaCodeType::setLocalCode()
     * @uses TaxAreaCodeType::setDistrictCode()
     * @uses TaxAreaCodeType::setInlieuCode()
     * @param string $countyCode
     * @param string $localCode
     * @param string $districtCode
     * @param string $inlieuCode
     */
    public function __construct($countyCode = null, $localCode = null, $districtCode = null, $inlieuCode = null)
    {
        $this
            ->setCountyCode($countyCode)
            ->setLocalCode($localCode)
            ->setDistrictCode($districtCode)
            ->setInlieuCode($inlieuCode);
    }
    /**
     * Get CountyCode value
     * @return string|null
     */
    public function getCountyCode()
    {
        return $this->CountyCode;
    }
    /**
     * Set CountyCode value
     * @param string $countyCode
     * @return \TomVaughan\StructType\TaxAreaCodeType
     */
    public function setCountyCode($countyCode = null)
    {
        // validation for constraint: string
        if (!is_null($countyCode) && !is_string($countyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countyCode, true), gettype($countyCode)), __LINE__);
        }
        $this->CountyCode = $countyCode;
        return $this;
    }
    /**
     * Get LocalCode value
     * @return string|null
     */
    public function getLocalCode()
    {
        return $this->LocalCode;
    }
    /**
     * Set LocalCode value
     * @param string $localCode
     * @return \TomVaughan\StructType\TaxAreaCodeType
     */
    public function setLocalCode($localCode = null)
    {
        // validation for constraint: string
        if (!is_null($localCode) && !is_string($localCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localCode, true), gettype($localCode)), __LINE__);
        }
        $this->LocalCode = $localCode;
        return $this;
    }
    /**
     * Get DistrictCode value
     * @return string|null
     */
    public function getDistrictCode()
    {
        return $this->DistrictCode;
    }
    /**
     * Set DistrictCode value
     * @param string $districtCode
     * @return \TomVaughan\StructType\TaxAreaCodeType
     */
    public function setDistrictCode($districtCode = null)
    {
        // validation for constraint: string
        if (!is_null($districtCode) && !is_string($districtCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($districtCode, true), gettype($districtCode)), __LINE__);
        }
        $this->DistrictCode = $districtCode;
        return $this;
    }
    /**
     * Get InlieuCode value
     * @return string|null
     */
    public function getInlieuCode()
    {
        return $this->InlieuCode;
    }
    /**
     * Set InlieuCode value
     * @param string $inlieuCode
     * @return \TomVaughan\StructType\TaxAreaCodeType
     */
    public function setInlieuCode($inlieuCode = null)
    {
        // validation for constraint: string
        if (!is_null($inlieuCode) && !is_string($inlieuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inlieuCode, true), gettype($inlieuCode)), __LINE__);
        }
        $this->InlieuCode = $inlieuCode;
        return $this;
    }
}
