<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredAddressType StructType
 * @subpackage Structs
 */
class RequiredAddressType extends AbstractStructBase
{
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The InCareOfName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InCareOfName;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Province;
    /**
     * The ZIPCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZIPCode;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * Constructor method for RequiredAddressType
     * @uses RequiredAddressType::setAddressLine1()
     * @uses RequiredAddressType::setAddressLine2()
     * @uses RequiredAddressType::setInCareOfName()
     * @uses RequiredAddressType::setCity()
     * @uses RequiredAddressType::setState()
     * @uses RequiredAddressType::setProvince()
     * @uses RequiredAddressType::setZIPCode()
     * @uses RequiredAddressType::setPostalCode()
     * @uses RequiredAddressType::setCountry()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $inCareOfName
     * @param string $city
     * @param string $state
     * @param string $province
     * @param string $zIPCode
     * @param string $postalCode
     * @param string $country
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $inCareOfName = null, $city = null, $state = null, $province = null, $zIPCode = null, $postalCode = null, $country = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setInCareOfName($inCareOfName)
            ->setCity($city)
            ->setState($state)
            ->setProvince($province)
            ->setZIPCode($zIPCode)
            ->setPostalCode($postalCode)
            ->setCountry($country);
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get InCareOfName value
     * @return string|null
     */
    public function getInCareOfName()
    {
        return $this->InCareOfName;
    }
    /**
     * Set InCareOfName value
     * @param string $inCareOfName
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setInCareOfName($inCareOfName = null)
    {
        // validation for constraint: string
        if (!is_null($inCareOfName) && !is_string($inCareOfName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inCareOfName, true), gettype($inCareOfName)), __LINE__);
        }
        $this->InCareOfName = $inCareOfName;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->Province;
    }
    /**
     * Set Province value
     * @param string $province
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        $this->Province = $province;
        return $this;
    }
    /**
     * Get ZIPCode value
     * @return string|null
     */
    public function getZIPCode()
    {
        return $this->ZIPCode;
    }
    /**
     * Set ZIPCode value
     * @param string $zIPCode
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setZIPCode($zIPCode = null)
    {
        // validation for constraint: string
        if (!is_null($zIPCode) && !is_string($zIPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zIPCode, true), gettype($zIPCode)), __LINE__);
        }
        $this->ZIPCode = $zIPCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \TomVaughan\StructType\RequiredAddressType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
}
