<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestHeaderType StructType
 * @subpackage Structs
 */
class RequestHeaderType extends AbstractStructBase
{
    /**
     * The FilingTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FilingTimestamp;
    /**
     * The FilingPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FilingPeriod;
    /**
     * The TypeOfFiling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeOfFiling;
    /**
     * The UsageType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $UsageType;
    /**
     * The TransmitterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransmitterID;
    /**
     * The SubmissionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubmissionID;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for RequestHeaderType
     * @uses RequestHeaderType::setFilingTimestamp()
     * @uses RequestHeaderType::setFilingPeriod()
     * @uses RequestHeaderType::setTypeOfFiling()
     * @uses RequestHeaderType::setUsageType()
     * @uses RequestHeaderType::setTransmitterID()
     * @uses RequestHeaderType::setSubmissionID()
     * @uses RequestHeaderType::setAccountNumber()
     * @param string $filingTimestamp
     * @param string $filingPeriod
     * @param string $typeOfFiling
     * @param string $usageType
     * @param string $transmitterID
     * @param string $submissionID
     * @param string $accountNumber
     */
    public function __construct($filingTimestamp = null, $filingPeriod = null, $typeOfFiling = null, $usageType = null, $transmitterID = null, $submissionID = null, $accountNumber = null)
    {
        $this
            ->setFilingTimestamp($filingTimestamp)
            ->setFilingPeriod($filingPeriod)
            ->setTypeOfFiling($typeOfFiling)
            ->setUsageType($usageType)
            ->setTransmitterID($transmitterID)
            ->setSubmissionID($submissionID)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get FilingTimestamp value
     * @return string
     */
    public function getFilingTimestamp()
    {
        return $this->FilingTimestamp;
    }
    /**
     * Set FilingTimestamp value
     * @param string $filingTimestamp
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setFilingTimestamp($filingTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($filingTimestamp) && !is_string($filingTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filingTimestamp, true), gettype($filingTimestamp)), __LINE__);
        }
        $this->FilingTimestamp = $filingTimestamp;
        return $this;
    }
    /**
     * Get FilingPeriod value
     * @return string
     */
    public function getFilingPeriod()
    {
        return $this->FilingPeriod;
    }
    /**
     * Set FilingPeriod value
     * @param string $filingPeriod
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setFilingPeriod($filingPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($filingPeriod) && !is_string($filingPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filingPeriod, true), gettype($filingPeriod)), __LINE__);
        }
        $this->FilingPeriod = $filingPeriod;
        return $this;
    }
    /**
     * Get TypeOfFiling value
     * @return string
     */
    public function getTypeOfFiling()
    {
        return $this->TypeOfFiling;
    }
    /**
     * Set TypeOfFiling value
     * @uses \TomVaughan\EnumType\FilingType::valueIsValid()
     * @uses \TomVaughan\EnumType\FilingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfFiling
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setTypeOfFiling($typeOfFiling = null)
    {
        // validation for constraint: enumeration
        if (!\TomVaughan\EnumType\FilingType::valueIsValid($typeOfFiling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TomVaughan\EnumType\FilingType', is_array($typeOfFiling) ? implode(', ', $typeOfFiling) : var_export($typeOfFiling, true), implode(', ', \TomVaughan\EnumType\FilingType::getValidValues())), __LINE__);
        }
        $this->TypeOfFiling = $typeOfFiling;
        return $this;
    }
    /**
     * Get UsageType value
     * @return string
     */
    public function getUsageType()
    {
        return $this->UsageType;
    }
    /**
     * Set UsageType value
     * @uses \TomVaughan\EnumType\UsageType::valueIsValid()
     * @uses \TomVaughan\EnumType\UsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usageType
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setUsageType($usageType = null)
    {
        // validation for constraint: enumeration
        if (!\TomVaughan\EnumType\UsageType::valueIsValid($usageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TomVaughan\EnumType\UsageType', is_array($usageType) ? implode(', ', $usageType) : var_export($usageType, true), implode(', ', \TomVaughan\EnumType\UsageType::getValidValues())), __LINE__);
        }
        $this->UsageType = $usageType;
        return $this;
    }
    /**
     * Get TransmitterID value
     * @return string|null
     */
    public function getTransmitterID()
    {
        return $this->TransmitterID;
    }
    /**
     * Set TransmitterID value
     * @param string $transmitterID
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setTransmitterID($transmitterID = null)
    {
        // validation for constraint: string
        if (!is_null($transmitterID) && !is_string($transmitterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitterID, true), gettype($transmitterID)), __LINE__);
        }
        $this->TransmitterID = $transmitterID;
        return $this;
    }
    /**
     * Get SubmissionID value
     * @return string|null
     */
    public function getSubmissionID()
    {
        return $this->SubmissionID;
    }
    /**
     * Set SubmissionID value
     * @param string $submissionID
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setSubmissionID($submissionID = null)
    {
        // validation for constraint: string
        if (!is_null($submissionID) && !is_string($submissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submissionID, true), gettype($submissionID)), __LINE__);
        }
        $this->SubmissionID = $submissionID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
}
