<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for makePrePayment StructType
 * @subpackage Structs
 */
class MakePrePayment extends AbstractStructBase
{
    /**
     * The RequestHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TomVaughan\StructType\RequestHeaderType
     */
    public $RequestHeader;
    /**
     * The PrepaymentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrepaymentData;
    /**
     * Constructor method for makePrePayment
     * @uses MakePrePayment::setRequestHeader()
     * @uses MakePrePayment::setPrepaymentData()
     * @param \TomVaughan\StructType\RequestHeaderType $requestHeader
     * @param string $prepaymentData
     */
    public function __construct(\TomVaughan\StructType\RequestHeaderType $requestHeader = null, $prepaymentData = null)
    {
        $this
            ->setRequestHeader($requestHeader)
            ->setPrepaymentData($prepaymentData);
    }
    /**
     * Get RequestHeader value
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function getRequestHeader()
    {
        return $this->RequestHeader;
    }
    /**
     * Set RequestHeader value
     * @param \TomVaughan\StructType\RequestHeaderType $requestHeader
     * @return \TomVaughan\StructType\MakePrePayment
     */
    public function setRequestHeader(\TomVaughan\StructType\RequestHeaderType $requestHeader = null)
    {
        $this->RequestHeader = $requestHeader;
        return $this;
    }
    /**
     * Get PrepaymentData value
     * @return string
     */
    public function getPrepaymentData()
    {
        return $this->PrepaymentData;
    }
    /**
     * Set PrepaymentData value
     * @param string $prepaymentData
     * @return \TomVaughan\StructType\MakePrePayment
     */
    public function setPrepaymentData($prepaymentData = null)
    {
        // validation for constraint: string
        if (!is_null($prepaymentData) && !is_string($prepaymentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaymentData, true), gettype($prepaymentData)), __LINE__);
        }
        $this->PrepaymentData = $prepaymentData;
        return $this;
    }
}
