<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubLocations StructType
 * @subpackage Structs
 */
class GetSubLocations extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The PeriodBeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodBeginDate;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * Constructor method for getSubLocations
     * @uses GetSubLocations::setAccountNumber()
     * @uses GetSubLocations::setPeriodBeginDate()
     * @uses GetSubLocations::setPeriodEndDate()
     * @param string $accountNumber
     * @param string $periodBeginDate
     * @param string $periodEndDate
     */
    public function __construct($accountNumber = null, $periodBeginDate = null, $periodEndDate = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setPeriodBeginDate($periodBeginDate)
            ->setPeriodEndDate($periodEndDate);
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \TomVaughan\StructType\GetSubLocations
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get PeriodBeginDate value
     * @return string
     */
    public function getPeriodBeginDate()
    {
        return $this->PeriodBeginDate;
    }
    /**
     * Set PeriodBeginDate value
     * @param string $periodBeginDate
     * @return \TomVaughan\StructType\GetSubLocations
     */
    public function setPeriodBeginDate($periodBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodBeginDate) && !is_string($periodBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodBeginDate, true), gettype($periodBeginDate)), __LINE__);
        }
        $this->PeriodBeginDate = $periodBeginDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \TomVaughan\StructType\GetSubLocations
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEndDate, true), gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
}
