<?php

namespace TomVaughan\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fileTaxReturn StructType
 * @subpackage Structs
 */
class FileTaxReturn extends AbstractStructBase
{
    /**
     * The RequestHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TomVaughan\StructType\RequestHeaderType
     */
    public $RequestHeader;
    /**
     * The TaxReturnData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxReturnData;
    /**
     * Constructor method for fileTaxReturn
     * @uses FileTaxReturn::setRequestHeader()
     * @uses FileTaxReturn::setTaxReturnData()
     * @param \TomVaughan\StructType\RequestHeaderType $requestHeader
     * @param string $taxReturnData
     */
    public function __construct(\TomVaughan\StructType\RequestHeaderType $requestHeader = null, $taxReturnData = null)
    {
        $this
            ->setRequestHeader($requestHeader)
            ->setTaxReturnData($taxReturnData);
    }
    /**
     * Get RequestHeader value
     * @return \TomVaughan\StructType\RequestHeaderType
     */
    public function getRequestHeader()
    {
        return $this->RequestHeader;
    }
    /**
     * Set RequestHeader value
     * @param \TomVaughan\StructType\RequestHeaderType $requestHeader
     * @return \TomVaughan\StructType\FileTaxReturn
     */
    public function setRequestHeader(\TomVaughan\StructType\RequestHeaderType $requestHeader = null)
    {
        $this->RequestHeader = $requestHeader;
        return $this;
    }
    /**
     * Get TaxReturnData value
     * @return string
     */
    public function getTaxReturnData()
    {
        return $this->TaxReturnData;
    }
    /**
     * Set TaxReturnData value
     * @param string $taxReturnData
     * @return \TomVaughan\StructType\FileTaxReturn
     */
    public function setTaxReturnData($taxReturnData = null)
    {
        // validation for constraint: string
        if (!is_null($taxReturnData) && !is_string($taxReturnData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxReturnData, true), gettype($taxReturnData)), __LINE__);
        }
        $this->TaxReturnData = $taxReturnData;
        return $this;
    }
}
