<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The msgType
     * @var int
     */
    public $msgType;
    /**
     * The fields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fields
     */
    public $fields;
    /**
     * Constructor method for response
     * @uses Response::setMsgType()
     * @uses Response::setFields()
     * @param int $msgType
     * @param \StructType\Fields $fields
     */
    public function __construct($msgType = null, \StructType\Fields $fields = null)
    {
        $this
            ->setMsgType($msgType)
            ->setFields($fields);
    }
    /**
     * Get msgType value
     * @return int|null
     */
    public function getMsgType()
    {
        return $this->msgType;
    }
    /**
     * Set msgType value
     * @param int $msgType
     * @return \StructType\Response
     */
    public function setMsgType($msgType = null)
    {
        // validation for constraint: int
        if (!is_null($msgType) && !(is_int($msgType) || ctype_digit($msgType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($msgType, true), gettype($msgType)), __LINE__);
        }
        $this->msgType = $msgType;
        return $this;
    }
    /**
     * Get fields value
     * @return \StructType\Fields|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \StructType\Fields $fields
     * @return \StructType\Response
     */
    public function setFields(\StructType\Fields $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
}
