<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackParcelResponse Structure
 * @subpackage Structs
 */
class TrackParcelResponse extends AbstractStructBase
{
    /**
     * The parcelID
     * @var int
     */
    public $parcelID;
    /**
     * The trackParcelStatus
     * @var string
     */
    public $trackParcelStatus;
    /**
     * The deliveryDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryDateTime;
    /**
     * The signer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $signer;
    /**
     * The freighterID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $freighterID;
    /**
     * The externalTrackingLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalTrackingLink;
    /**
     * The trackParcelActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var TrackParcelActivity[]
     */
    public $trackParcelActivities;
    /**
     * Constructor method for trackParcelResponse
     * @uses TrackParcelResponse::setParcelID()
     * @uses TrackParcelResponse::setTrackParcelStatus()
     * @uses TrackParcelResponse::setDeliveryDateTime()
     * @uses TrackParcelResponse::setSigner()
     * @uses TrackParcelResponse::setFreighterID()
     * @uses TrackParcelResponse::setExternalTrackingLink()
     * @uses TrackParcelResponse::setTrackParcelActivities()
     * @param int $parcelID
     * @param string $trackParcelStatus
     * @param string $deliveryDateTime
     * @param string $signer
     * @param string $freighterID
     * @param string $externalTrackingLink
     * @param TrackParcelActivity[] $trackParcelActivities
     */
    public function __construct($parcelID = null, $trackParcelStatus = null, $deliveryDateTime = null, $signer = null, $freighterID = null, $externalTrackingLink = null, array $trackParcelActivities = array())
    {
        $this
            ->setParcelID($parcelID)
            ->setTrackParcelStatus($trackParcelStatus)
            ->setDeliveryDateTime($deliveryDateTime)
            ->setSigner($signer)
            ->setFreighterID($freighterID)
            ->setExternalTrackingLink($externalTrackingLink)
            ->setTrackParcelActivities($trackParcelActivities);
    }
    /**
     * Get parcelID value
     * @return int|null
     */
    public function getParcelID()
    {
        return $this->parcelID;
    }
    /**
     * Set parcelID value
     * @param int $parcelID
     * @return TrackParcelResponse
     */
    public function setParcelID($parcelID = null)
    {
        // validation for constraint: int
        if (!is_null($parcelID) && !(is_int($parcelID) || ctype_digit($parcelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelID, true), gettype($parcelID)), __LINE__);
        }
        $this->parcelID = $parcelID;
        return $this;
    }
    /**
     * Get trackParcelStatus value
     * @return string|null
     */
    public function getTrackParcelStatus()
    {
        return $this->trackParcelStatus;
    }
    /**
     * Set trackParcelStatus value
     * @uses TrackParcelStatus::valueIsValid()
     * @uses TrackParcelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trackParcelStatus
     * @return TrackParcelResponse
     */
    public function setTrackParcelStatus($trackParcelStatus = null)
    {
        // validation for constraint: enumeration
        if (!TrackParcelStatus::valueIsValid($trackParcelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TrackParcelStatus', is_array($trackParcelStatus) ? implode(', ', $trackParcelStatus) : var_export($trackParcelStatus, true), implode(', ', TrackParcelStatus::getValidValues())), __LINE__);
        }
        $this->trackParcelStatus = $trackParcelStatus;
        return $this;
    }
    /**
     * Get deliveryDateTime value
     * @return string|null
     */
    public function getDeliveryDateTime()
    {
        return $this->deliveryDateTime;
    }
    /**
     * Set deliveryDateTime value
     * @param string $deliveryDateTime
     * @return TrackParcelResponse
     */
    public function setDeliveryDateTime($deliveryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDateTime) && !is_string($deliveryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDateTime, true), gettype($deliveryDateTime)), __LINE__);
        }
        $this->deliveryDateTime = $deliveryDateTime;
        return $this;
    }
    /**
     * Get signer value
     * @return string|null
     */
    public function getSigner()
    {
        return $this->signer;
    }
    /**
     * Set signer value
     * @param string $signer
     * @return TrackParcelResponse
     */
    public function setSigner($signer = null)
    {
        // validation for constraint: string
        if (!is_null($signer) && !is_string($signer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signer, true), gettype($signer)), __LINE__);
        }
        $this->signer = $signer;
        return $this;
    }
    /**
     * Get freighterID value
     * @return string|null
     */
    public function getFreighterID()
    {
        return $this->freighterID;
    }
    /**
     * Set freighterID value
     * @param string $freighterID
     * @return TrackParcelResponse
     */
    public function setFreighterID($freighterID = null)
    {
        // validation for constraint: string
        if (!is_null($freighterID) && !is_string($freighterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freighterID, true), gettype($freighterID)), __LINE__);
        }
        $this->freighterID = $freighterID;
        return $this;
    }
    /**
     * Get externalTrackingLink value
     * @return string|null
     */
    public function getExternalTrackingLink()
    {
        return $this->externalTrackingLink;
    }
    /**
     * Set externalTrackingLink value
     * @param string $externalTrackingLink
     * @return TrackParcelResponse
     */
    public function setExternalTrackingLink($externalTrackingLink = null)
    {
        // validation for constraint: string
        if (!is_null($externalTrackingLink) && !is_string($externalTrackingLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTrackingLink, true), gettype($externalTrackingLink)), __LINE__);
        }
        $this->externalTrackingLink = $externalTrackingLink;
        return $this;
    }
    /**
     * Get trackParcelActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return TrackParcelActivity[]|null
     */
    public function getTrackParcelActivities()
    {
        return isset($this->trackParcelActivities) ? $this->trackParcelActivities : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackParcelActivities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackParcelActivities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackParcelActivitiesForArrayConstraintsFromSetTrackParcelActivities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackParcelResponseTrackParcelActivitiesItem) {
            // validation for constraint: itemType
            if (!$trackParcelResponseTrackParcelActivitiesItem instanceof TrackParcelActivity) {
                $invalidValues[] = is_object($trackParcelResponseTrackParcelActivitiesItem) ? get_class($trackParcelResponseTrackParcelActivitiesItem) : sprintf('%s(%s)', gettype($trackParcelResponseTrackParcelActivitiesItem), var_export($trackParcelResponseTrackParcelActivitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The trackParcelActivities property can only contain items of type TrackParcelActivity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set trackParcelActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param TrackParcelActivity[] $trackParcelActivities
     * @return TrackParcelResponse
     */
    public function setTrackParcelActivities(array $trackParcelActivities = array())
    {
        // validation for constraint: array
        if ('' !== ($trackParcelActivitiesArrayErrorMessage = self::validateTrackParcelActivitiesForArrayConstraintsFromSetTrackParcelActivities($trackParcelActivities))) {
            throw new \InvalidArgumentException($trackParcelActivitiesArrayErrorMessage, __LINE__);
        }
        if (is_null($trackParcelActivities) || (is_array($trackParcelActivities) && empty($trackParcelActivities))) {
            unset($this->trackParcelActivities);
        } else {
            $this->trackParcelActivities = $trackParcelActivities;
        }
        return $this;
    }
    /**
     * Add item to trackParcelActivities value
     * @throws \InvalidArgumentException
     * @param TrackParcelActivity $item
     * @return TrackParcelResponse
     */
    public function addToTrackParcelActivities(TrackParcelActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackParcelActivity) {
            throw new \InvalidArgumentException(sprintf('The trackParcelActivities property can only contain items of type TrackParcelActivity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->trackParcelActivities[] = $item;
        return $this;
    }
}
