<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackParcelActivity Structure
 * @subpackage Structs
 */
class TrackParcelActivity extends AbstractStructBase
{
    /**
     * The activityDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activityDateTime;
    /**
     * The supplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $supplier;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $person;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The delivered
     * @var bool
     */
    public $delivered;
    /**
     * Constructor method for trackParcelActivity
     * @uses TrackParcelActivity::setActivityDateTime()
     * @uses TrackParcelActivity::setSupplier()
     * @uses TrackParcelActivity::setStatus()
     * @uses TrackParcelActivity::setLocation()
     * @uses TrackParcelActivity::setPerson()
     * @uses TrackParcelActivity::setCountry()
     * @uses TrackParcelActivity::setCountryCode()
     * @uses TrackParcelActivity::setDelivered()
     * @param string $activityDateTime
     * @param string $supplier
     * @param string $status
     * @param string $location
     * @param string $person
     * @param string $country
     * @param string $countryCode
     * @param bool $delivered
     */
    public function __construct($activityDateTime = null, $supplier = null, $status = null, $location = null, $person = null, $country = null, $countryCode = null, $delivered = null)
    {
        $this
            ->setActivityDateTime($activityDateTime)
            ->setSupplier($supplier)
            ->setStatus($status)
            ->setLocation($location)
            ->setPerson($person)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setDelivered($delivered);
    }
    /**
     * Get activityDateTime value
     * @return string|null
     */
    public function getActivityDateTime()
    {
        return $this->activityDateTime;
    }
    /**
     * Set activityDateTime value
     * @param string $activityDateTime
     * @return TrackParcelActivity
     */
    public function setActivityDateTime($activityDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($activityDateTime) && !is_string($activityDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDateTime, true), gettype($activityDateTime)), __LINE__);
        }
        $this->activityDateTime = $activityDateTime;
        return $this;
    }
    /**
     * Get supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->supplier;
    }
    /**
     * Set supplier value
     * @param string $supplier
     * @return TrackParcelActivity
     */
    public function setSupplier($supplier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier) && !is_string($supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier, true), gettype($supplier)), __LINE__);
        }
        $this->supplier = $supplier;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return TrackParcelActivity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return TrackParcelActivity
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get person value
     * @return string|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param string $person
     * @return TrackParcelActivity
     */
    public function setPerson($person = null)
    {
        // validation for constraint: string
        if (!is_null($person) && !is_string($person)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person, true), gettype($person)), __LINE__);
        }
        $this->person = $person;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return TrackParcelActivity
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return TrackParcelActivity
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get delivered value
     * @return bool|null
     */
    public function getDelivered()
    {
        return $this->delivered;
    }
    /**
     * Set delivered value
     * @param bool $delivered
     * @return TrackParcelActivity
     */
    public function setDelivered($delivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($delivered) && !is_bool($delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delivered, true), gettype($delivered)), __LINE__);
        }
        $this->delivered = $delivered;
        return $this;
    }
}
