<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trackConsignmentResponse Structure
 * @subpackage Structs
 */
class TrackConsignmentResponse extends AbstractStructBase
{
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The reference
     * @var int
     */
    public $reference;
    /**
     * The delivered
     * @var bool
     */
    public $delivered;
    /**
     * The handover
     * @var bool
     */
    public $handover;
    /**
     * The deliveredCount
     * @var int
     */
    public $deliveredCount;
    /**
     * The billed
     * @var bool
     */
    public $billed;
    /**
     * The canceled
     * @var bool
     */
    public $canceled;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The mixedWeight
     * @var float
     */
    public $mixedWeight;
    /**
     * The distance
     * @var float
     */
    public $distance;
    /**
     * The ratename
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ratename;
    /**
     * The trackParcelResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var TrackParcelResponse[]
     */
    public $trackParcelResponse;
    /**
     * Constructor method for trackConsignmentResponse
     * @uses TrackConsignmentResponse::setConsignmentID()
     * @uses TrackConsignmentResponse::setReference()
     * @uses TrackConsignmentResponse::setDelivered()
     * @uses TrackConsignmentResponse::setHandover()
     * @uses TrackConsignmentResponse::setDeliveredCount()
     * @uses TrackConsignmentResponse::setBilled()
     * @uses TrackConsignmentResponse::setCanceled()
     * @uses TrackConsignmentResponse::setPrice()
     * @uses TrackConsignmentResponse::setMixedWeight()
     * @uses TrackConsignmentResponse::setDistance()
     * @uses TrackConsignmentResponse::setRatename()
     * @uses TrackConsignmentResponse::setTrackParcelResponse()
     * @param int $consignmentID
     * @param int $reference
     * @param bool $delivered
     * @param bool $handover
     * @param int $deliveredCount
     * @param bool $billed
     * @param bool $canceled
     * @param float $price
     * @param float $mixedWeight
     * @param float $distance
     * @param string $ratename
     * @param TrackParcelResponse[] $trackParcelResponse
     */
    public function __construct($consignmentID = null, $reference = null, $delivered = null, $handover = null, $deliveredCount = null, $billed = null, $canceled = null, $price = null, $mixedWeight = null, $distance = null, $ratename = null, array $trackParcelResponse = array())
    {
        $this
            ->setConsignmentID($consignmentID)
            ->setReference($reference)
            ->setDelivered($delivered)
            ->setHandover($handover)
            ->setDeliveredCount($deliveredCount)
            ->setBilled($billed)
            ->setCanceled($canceled)
            ->setPrice($price)
            ->setMixedWeight($mixedWeight)
            ->setDistance($distance)
            ->setRatename($ratename)
            ->setTrackParcelResponse($trackParcelResponse);
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return TrackConsignmentResponse
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get reference value
     * @return int|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param int $reference
     * @return TrackConsignmentResponse
     */
    public function setReference($reference = null)
    {
        // validation for constraint: int
        if (!is_null($reference) && !(is_int($reference) || ctype_digit($reference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get delivered value
     * @return bool|null
     */
    public function getDelivered()
    {
        return $this->delivered;
    }
    /**
     * Set delivered value
     * @param bool $delivered
     * @return TrackConsignmentResponse
     */
    public function setDelivered($delivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($delivered) && !is_bool($delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delivered, true), gettype($delivered)), __LINE__);
        }
        $this->delivered = $delivered;
        return $this;
    }
    /**
     * Get handover value
     * @return bool|null
     */
    public function getHandover()
    {
        return $this->handover;
    }
    /**
     * Set handover value
     * @param bool $handover
     * @return TrackConsignmentResponse
     */
    public function setHandover($handover = null)
    {
        // validation for constraint: boolean
        if (!is_null($handover) && !is_bool($handover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($handover, true), gettype($handover)), __LINE__);
        }
        $this->handover = $handover;
        return $this;
    }
    /**
     * Get deliveredCount value
     * @return int|null
     */
    public function getDeliveredCount()
    {
        return $this->deliveredCount;
    }
    /**
     * Set deliveredCount value
     * @param int $deliveredCount
     * @return TrackConsignmentResponse
     */
    public function setDeliveredCount($deliveredCount = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredCount) && !(is_int($deliveredCount) || ctype_digit($deliveredCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredCount, true), gettype($deliveredCount)), __LINE__);
        }
        $this->deliveredCount = $deliveredCount;
        return $this;
    }
    /**
     * Get billed value
     * @return bool|null
     */
    public function getBilled()
    {
        return $this->billed;
    }
    /**
     * Set billed value
     * @param bool $billed
     * @return TrackConsignmentResponse
     */
    public function setBilled($billed = null)
    {
        // validation for constraint: boolean
        if (!is_null($billed) && !is_bool($billed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billed, true), gettype($billed)), __LINE__);
        }
        $this->billed = $billed;
        return $this;
    }
    /**
     * Get canceled value
     * @return bool|null
     */
    public function getCanceled()
    {
        return $this->canceled;
    }
    /**
     * Set canceled value
     * @param bool $canceled
     * @return TrackConsignmentResponse
     */
    public function setCanceled($canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canceled) && !is_bool($canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canceled, true), gettype($canceled)), __LINE__);
        }
        $this->canceled = $canceled;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return TrackConsignmentResponse
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get mixedWeight value
     * @return float|null
     */
    public function getMixedWeight()
    {
        return $this->mixedWeight;
    }
    /**
     * Set mixedWeight value
     * @param float $mixedWeight
     * @return TrackConsignmentResponse
     */
    public function setMixedWeight($mixedWeight = null)
    {
        // validation for constraint: float
        if (!is_null($mixedWeight) && !(is_float($mixedWeight) || is_numeric($mixedWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mixedWeight, true), gettype($mixedWeight)), __LINE__);
        }
        $this->mixedWeight = $mixedWeight;
        return $this;
    }
    /**
     * Get distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param float $distance
     * @return TrackConsignmentResponse
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: float
        if (!is_null($distance) && !(is_float($distance) || is_numeric($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get ratename value
     * @return string|null
     */
    public function getRatename()
    {
        return $this->ratename;
    }
    /**
     * Set ratename value
     * @param string $ratename
     * @return TrackConsignmentResponse
     */
    public function setRatename($ratename = null)
    {
        // validation for constraint: string
        if (!is_null($ratename) && !is_string($ratename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratename, true), gettype($ratename)), __LINE__);
        }
        $this->ratename = $ratename;
        return $this;
    }
    /**
     * Get trackParcelResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return TrackParcelResponse[]|null
     */
    public function getTrackParcelResponse()
    {
        return isset($this->trackParcelResponse) ? $this->trackParcelResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackParcelResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackParcelResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackParcelResponseForArrayConstraintsFromSetTrackParcelResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackConsignmentResponseTrackParcelResponseItem) {
            // validation for constraint: itemType
            if (!$trackConsignmentResponseTrackParcelResponseItem instanceof TrackParcelResponse) {
                $invalidValues[] = is_object($trackConsignmentResponseTrackParcelResponseItem) ? get_class($trackConsignmentResponseTrackParcelResponseItem) : sprintf('%s(%s)', gettype($trackConsignmentResponseTrackParcelResponseItem), var_export($trackConsignmentResponseTrackParcelResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The trackParcelResponse property can only contain items of type TrackParcelResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set trackParcelResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param TrackParcelResponse[] $trackParcelResponse
     * @return TrackConsignmentResponse
     */
    public function setTrackParcelResponse(array $trackParcelResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($trackParcelResponseArrayErrorMessage = self::validateTrackParcelResponseForArrayConstraintsFromSetTrackParcelResponse($trackParcelResponse))) {
            throw new \InvalidArgumentException($trackParcelResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($trackParcelResponse) || (is_array($trackParcelResponse) && empty($trackParcelResponse))) {
            unset($this->trackParcelResponse);
        } else {
            $this->trackParcelResponse = $trackParcelResponse;
        }
        return $this;
    }
    /**
     * Add item to trackParcelResponse value
     * @throws \InvalidArgumentException
     * @param TrackParcelResponse $item
     * @return TrackConsignmentResponse
     */
    public function addToTrackParcelResponse(TrackParcelResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TrackParcelResponse) {
            throw new \InvalidArgumentException(sprintf('The trackParcelResponse property can only contain items of type TrackParcelResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->trackParcelResponse[] = $item;
        return $this;
    }
}
