<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for status Structure
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The messages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $messages;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for status
     * @uses Status::setErrorCode()
     * @uses Status::setMessages()
     * @uses Status::setStatus()
     * @param string $errorCode
     * @param string[] $messages
     * @param string $status
     */
    public function __construct($errorCode = null, array $messages = array(), $status = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setMessages($messages)
            ->setStatus($status);
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses ErrorCode::valueIsValid()
     * @uses ErrorCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return Status
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!ErrorCode::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class ErrorCode', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', ErrorCode::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getMessages()
    {
        return isset($this->messages) ? $this->messages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagesForArrayConstraintsFromSetMessages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusMessagesItem) {
            // validation for constraint: itemType
            if (!is_string($statusMessagesItem)) {
                $invalidValues[] = is_object($statusMessagesItem) ? get_class($statusMessagesItem) : sprintf('%s(%s)', gettype($statusMessagesItem), var_export($statusMessagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The messages property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $messages
     * @return Status
     */
    public function setMessages(array $messages = array())
    {
        // validation for constraint: array
        if ('' !== ($messagesArrayErrorMessage = self::validateMessagesForArrayConstraintsFromSetMessages($messages))) {
            throw new \InvalidArgumentException($messagesArrayErrorMessage, __LINE__);
        }
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->messages);
        } else {
            $this->messages = $messages;
        }
        return $this;
    }
    /**
     * Add item to messages value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return Status
     */
    public function addToMessages($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The messages property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->messages[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses StatusCode::valueIsValid()
     * @uses StatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return Status
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!StatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusCode', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', StatusCode::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
