<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rateConsignmentResponse Structure
 * @subpackage Structs
 */
class RateConsignmentResponse extends AbstractStructBase
{
    /**
     * The yourReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yourReference;
    /**
     * The rateInformations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var RateInformation[]
     */
    public $rateInformations;
    /**
     * Constructor method for rateConsignmentResponse
     * @uses RateConsignmentResponse::setYourReference()
     * @uses RateConsignmentResponse::setRateInformations()
     * @param string $yourReference
     * @param RateInformation[] $rateInformations
     */
    public function __construct($yourReference = null, array $rateInformations = array())
    {
        $this
            ->setYourReference($yourReference)
            ->setRateInformations($rateInformations);
    }
    /**
     * Get yourReference value
     * @return string|null
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }
    /**
     * Set yourReference value
     * @param string $yourReference
     * @return RateConsignmentResponse
     */
    public function setYourReference($yourReference = null)
    {
        // validation for constraint: string
        if (!is_null($yourReference) && !is_string($yourReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yourReference, true), gettype($yourReference)), __LINE__);
        }
        $this->yourReference = $yourReference;
        return $this;
    }
    /**
     * Get rateInformations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RateInformation[]|null
     */
    public function getRateInformations()
    {
        return isset($this->rateInformations) ? $this->rateInformations : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRateInformations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateInformations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateInformationsForArrayConstraintsFromSetRateInformations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateConsignmentResponseRateInformationsItem) {
            // validation for constraint: itemType
            if (!$rateConsignmentResponseRateInformationsItem instanceof RateInformation) {
                $invalidValues[] = is_object($rateConsignmentResponseRateInformationsItem) ? get_class($rateConsignmentResponseRateInformationsItem) : sprintf('%s(%s)', gettype($rateConsignmentResponseRateInformationsItem), var_export($rateConsignmentResponseRateInformationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rateInformations property can only contain items of type RateInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rateInformations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param RateInformation[] $rateInformations
     * @return RateConsignmentResponse
     */
    public function setRateInformations(array $rateInformations = array())
    {
        // validation for constraint: array
        if ('' !== ($rateInformationsArrayErrorMessage = self::validateRateInformationsForArrayConstraintsFromSetRateInformations($rateInformations))) {
            throw new \InvalidArgumentException($rateInformationsArrayErrorMessage, __LINE__);
        }
        if (is_null($rateInformations) || (is_array($rateInformations) && empty($rateInformations))) {
            unset($this->rateInformations);
        } else {
            $this->rateInformations = $rateInformations;
        }
        return $this;
    }
    /**
     * Add item to rateInformations value
     * @throws \InvalidArgumentException
     * @param RateInformation $item
     * @return RateConsignmentResponse
     */
    public function addToRateInformations(RateInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof RateInformation) {
            throw new \InvalidArgumentException(sprintf('The rateInformations property can only contain items of type RateInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rateInformations[] = $item;
        return $this;
    }
}
