<?php
use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for rate Enums
 * @subpackage Enumerations
 */
class Rate extends AbstractStructEnumBase
{
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Constant for value 'EXPRESS'
     * @return string 'EXPRESS'
     */
    const VALUE_EXPRESS = 'EXPRESS';
    /**
     * Constant for value 'CARGO'
     * @return string 'CARGO'
     */
    const VALUE_CARGO = 'CARGO';
    /**
     * Constant for value 'SPECIAL'
     * @return string 'SPECIAL'
     */
    const VALUE_SPECIAL = 'SPECIAL';
    /**
     * Constant for value 'CUSTOM'
     * @return string 'CUSTOM'
     */
    const VALUE_CUSTOM = 'CUSTOM';
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_EXPRESS
     * @uses self::VALUE_CARGO
     * @uses self::VALUE_SPECIAL
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_EXPRESS,
            self::VALUE_CARGO,
            self::VALUE_SPECIAL,
            self::VALUE_CUSTOM,
        );
    }
}
