<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel Structure
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The weight
     * @var float
     */
    public $weight;
    /**
     * The length
     * @var int
     */
    public $length;
    /**
     * The width
     * @var int
     */
    public $width;
    /**
     * The height
     * @var int
     */
    public $height;
    /**
     * The content
     * @var string
     */
    public $content;
    /**
     * The packaging
     * @var string
     */
    public $packaging;
    /**
     * Constructor method for parcel
     * @uses Parcel::setAmount()
     * @uses Parcel::setWeight()
     * @uses Parcel::setLength()
     * @uses Parcel::setWidth()
     * @uses Parcel::setHeight()
     * @uses Parcel::setContent()
     * @uses Parcel::setPackaging()
     * @param float $amount
     * @param float $weight
     * @param int $length
     * @param int $width
     * @param int $height
     * @param string $content
     * @param string $packaging
     */
    public function __construct($amount = null, $weight = null, $length = null, $width = null, $height = null, $content = null, $packaging = null)
    {
        $this
            ->setAmount($amount)
            ->setWeight($weight)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setContent($content)
            ->setPackaging($packaging);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return Parcel
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return Parcel
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return Parcel
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param int $height
     * @return Parcel
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return Parcel
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get packaging value
     * @return string|null
     */
    public function getPackaging()
    {
        return $this->packaging;
    }
    /**
     * Set packaging value
     * @uses PackagingType::valueIsValid()
     * @uses PackagingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packaging
     * @return Parcel
     */
    public function setPackaging($packaging = null)
    {
        // validation for constraint: enumeration
        if (!PackagingType::valueIsValid($packaging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PackagingType', is_array($packaging) ? implode(', ', $packaging) : var_export($packaging, true), implode(', ', PackagingType::getValidValues())), __LINE__);
        }
        $this->packaging = $packaging;
        return $this;
    }
}
