<?php
use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for currency Enums
 * @subpackage Enumerations
 */
class Currency extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'USD'
     * @return string 'USD'
     */
    const VALUE_USD = 'USD';
    /**
     * Constant for value 'CHF'
     * @return string 'CHF'
     */
    const VALUE_CHF = 'CHF';
    /**
     * Return allowed values
     * @uses self::VALUE_EUR
     * @uses self::VALUE_USD
     * @uses self::VALUE_CHF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EUR,
            self::VALUE_USD,
            self::VALUE_CHF,
        );
    }
}
