<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelRequest Structure
 * @subpackage Structs
 */
class CancelRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The cancelConsignments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var CancelConsignment[]
     */
    public $cancelConsignments;
    /**
     * Constructor method for cancelRequest
     * @uses CancelRequest::setCredentials()
     * @uses CancelRequest::setCancelConsignments()
     * @param Credential $credentials
     * @param CancelConsignment[] $cancelConsignments
     */
    public function __construct(Credential $credentials = null, array $cancelConsignments = array())
    {
        $this
            ->setCredentials($credentials)
            ->setCancelConsignments($cancelConsignments);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return CancelRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get cancelConsignments value
     * @return CancelConsignment[]|null
     */
    public function getCancelConsignments()
    {
        return $this->cancelConsignments;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelConsignments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelConsignments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelConsignmentsForArrayConstraintsFromSetCancelConsignments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelRequestCancelConsignmentsItem) {
            // validation for constraint: itemType
            if (!$cancelRequestCancelConsignmentsItem instanceof CancelConsignment) {
                $invalidValues[] = is_object($cancelRequestCancelConsignmentsItem) ? get_class($cancelRequestCancelConsignmentsItem) : sprintf('%s(%s)', gettype($cancelRequestCancelConsignmentsItem), var_export($cancelRequestCancelConsignmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cancelConsignments property can only contain items of type CancelConsignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cancelConsignments value
     * @throws \InvalidArgumentException
     * @param CancelConsignment[] $cancelConsignments
     * @return CancelRequest
     */
    public function setCancelConsignments(array $cancelConsignments = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelConsignmentsArrayErrorMessage = self::validateCancelConsignmentsForArrayConstraintsFromSetCancelConsignments($cancelConsignments))) {
            throw new \InvalidArgumentException($cancelConsignmentsArrayErrorMessage, __LINE__);
        }
        $this->cancelConsignments = $cancelConsignments;
        return $this;
    }
    /**
     * Add item to cancelConsignments value
     * @throws \InvalidArgumentException
     * @param CancelConsignment $item
     * @return CancelRequest
     */
    public function addToCancelConsignments(CancelConsignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CancelConsignment) {
            throw new \InvalidArgumentException(sprintf('The cancelConsignments property can only contain items of type CancelConsignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cancelConsignments[] = $item;
        return $this;
    }
}
