<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelConsignment Structure
 * @subpackage Structs
 */
class CancelConsignment extends AbstractStructBase
{
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for cancelConsignment
     * @uses CancelConsignment::setConsignmentID()
     * @uses CancelConsignment::setReason()
     * @param int $consignmentID
     * @param string $reason
     */
    public function __construct($consignmentID = null, $reason = null)
    {
        $this
            ->setConsignmentID($consignmentID)
            ->setReason($reason);
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return CancelConsignment
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return CancelConsignment
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
}
