<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookResponseType Structure
 * @subpackage Structs
 */
class BookResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The consignmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ConsignmentResponse[]
     */
    public $consignmentResponses;
    /**
     * Constructor method for bookResponseType
     * @uses BookResponseType::setStatus()
     * @uses BookResponseType::setConsignmentResponses()
     * @param Status $status
     * @param ConsignmentResponse[] $consignmentResponses
     */
    public function __construct(Status $status = null, array $consignmentResponses = array())
    {
        $this
            ->setStatus($status)
            ->setConsignmentResponses($consignmentResponses);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return BookResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get consignmentResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ConsignmentResponse[]|null
     */
    public function getConsignmentResponses()
    {
        return isset($this->consignmentResponses) ? $this->consignmentResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentResponsesForArrayConstraintsFromSetConsignmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookResponseTypeConsignmentResponsesItem) {
            // validation for constraint: itemType
            if (!$bookResponseTypeConsignmentResponsesItem instanceof ConsignmentResponse) {
                $invalidValues[] = is_object($bookResponseTypeConsignmentResponsesItem) ? get_class($bookResponseTypeConsignmentResponsesItem) : sprintf('%s(%s)', gettype($bookResponseTypeConsignmentResponsesItem), var_export($bookResponseTypeConsignmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignmentResponses property can only contain items of type ConsignmentResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignmentResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ConsignmentResponse[] $consignmentResponses
     * @return BookResponseType
     */
    public function setConsignmentResponses(array $consignmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentResponsesArrayErrorMessage = self::validateConsignmentResponsesForArrayConstraintsFromSetConsignmentResponses($consignmentResponses))) {
            throw new \InvalidArgumentException($consignmentResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($consignmentResponses) || (is_array($consignmentResponses) && empty($consignmentResponses))) {
            unset($this->consignmentResponses);
        } else {
            $this->consignmentResponses = $consignmentResponses;
        }
        return $this;
    }
    /**
     * Add item to consignmentResponses value
     * @throws \InvalidArgumentException
     * @param ConsignmentResponse $item
     * @return BookResponseType
     */
    public function addToConsignmentResponses(ConsignmentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ConsignmentResponse) {
            throw new \InvalidArgumentException(sprintf('The consignmentResponses property can only contain items of type ConsignmentResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignmentResponses[] = $item;
        return $this;
    }
}
