<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billRequest Structure
 * @subpackage Structs
 */
class BillRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The billDateFrom
     * @var string
     */
    public $billDateFrom;
    /**
     * The billDateTo
     * @var string
     */
    public $billDateTo;
    /**
     * The document
     * @var bool
     */
    public $document;
    /**
     * Constructor method for billRequest
     * @uses BillRequest::setCredentials()
     * @uses BillRequest::setBillDateFrom()
     * @uses BillRequest::setBillDateTo()
     * @uses BillRequest::setDocument()
     * @param Credential $credentials
     * @param string $billDateFrom
     * @param string $billDateTo
     * @param bool $document
     */
    public function __construct(Credential $credentials = null, $billDateFrom = null, $billDateTo = null, $document = null)
    {
        $this
            ->setCredentials($credentials)
            ->setBillDateFrom($billDateFrom)
            ->setBillDateTo($billDateTo)
            ->setDocument($document);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return BillRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get billDateFrom value
     * @return string|null
     */
    public function getBillDateFrom()
    {
        return $this->billDateFrom;
    }
    /**
     * Set billDateFrom value
     * @param string $billDateFrom
     * @return BillRequest
     */
    public function setBillDateFrom($billDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($billDateFrom) && !is_string($billDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDateFrom, true), gettype($billDateFrom)), __LINE__);
        }
        $this->billDateFrom = $billDateFrom;
        return $this;
    }
    /**
     * Get billDateTo value
     * @return string|null
     */
    public function getBillDateTo()
    {
        return $this->billDateTo;
    }
    /**
     * Set billDateTo value
     * @param string $billDateTo
     * @return BillRequest
     */
    public function setBillDateTo($billDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($billDateTo) && !is_string($billDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDateTo, true), gettype($billDateTo)), __LINE__);
        }
        $this->billDateTo = $billDateTo;
        return $this;
    }
    /**
     * Get document value
     * @return bool|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param bool $document
     * @return BillRequest
     */
    public function setDocument($document = null)
    {
        // validation for constraint: boolean
        if (!is_null($document) && !is_bool($document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($document, true), gettype($document)), __LINE__);
        }
        $this->document = $document;
        return $this;
    }
}
