<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rateResponseType Structure
 * @subpackage Structs
 */
class RateResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The rateConsignmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var RateConsignmentResponse[]
     */
    public $rateConsignmentResponses;
    /**
     * Constructor method for rateResponseType
     * @uses RateResponseType::setStatus()
     * @uses RateResponseType::setRateConsignmentResponses()
     * @param Status $status
     * @param RateConsignmentResponse[] $rateConsignmentResponses
     */
    public function __construct(Status $status = null, array $rateConsignmentResponses = array())
    {
        $this
            ->setStatus($status)
            ->setRateConsignmentResponses($rateConsignmentResponses);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return RateResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get rateConsignmentResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RateConsignmentResponse[]|null
     */
    public function getRateConsignmentResponses()
    {
        return isset($this->rateConsignmentResponses) ? $this->rateConsignmentResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRateConsignmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateConsignmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateConsignmentResponsesForArrayConstraintsFromSetRateConsignmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateResponseTypeRateConsignmentResponsesItem) {
            // validation for constraint: itemType
            if (!$rateResponseTypeRateConsignmentResponsesItem instanceof RateConsignmentResponse) {
                $invalidValues[] = is_object($rateResponseTypeRateConsignmentResponsesItem) ? get_class($rateResponseTypeRateConsignmentResponsesItem) : sprintf('%s(%s)', gettype($rateResponseTypeRateConsignmentResponsesItem), var_export($rateResponseTypeRateConsignmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rateConsignmentResponses property can only contain items of type RateConsignmentResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rateConsignmentResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param RateConsignmentResponse[] $rateConsignmentResponses
     * @return RateResponseType
     */
    public function setRateConsignmentResponses(array $rateConsignmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($rateConsignmentResponsesArrayErrorMessage = self::validateRateConsignmentResponsesForArrayConstraintsFromSetRateConsignmentResponses($rateConsignmentResponses))) {
            throw new \InvalidArgumentException($rateConsignmentResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($rateConsignmentResponses) || (is_array($rateConsignmentResponses) && empty($rateConsignmentResponses))) {
            unset($this->rateConsignmentResponses);
        } else {
            $this->rateConsignmentResponses = $rateConsignmentResponses;
        }
        return $this;
    }
    /**
     * Add item to rateConsignmentResponses value
     * @throws \InvalidArgumentException
     * @param RateConsignmentResponse $item
     * @return RateResponseType
     */
    public function addToRateConsignmentResponses(RateConsignmentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof RateConsignmentResponse) {
            throw new \InvalidArgumentException(sprintf('The rateConsignmentResponses property can only contain items of type RateConsignmentResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rateConsignmentResponses[] = $item;
        return $this;
    }
}
