<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rateInformation Structure
 * @subpackage Structs
 */
class RateInformation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The rateID
     * @var int
     */
    public $rateID;
    /**
     * The typeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeName;
    /**
     * Constructor method for rateInformation
     * @uses RateInformation::setName()
     * @uses RateInformation::setPrice()
     * @uses RateInformation::setRateID()
     * @uses RateInformation::setTypeName()
     * @param string $name
     * @param float $price
     * @param int $rateID
     * @param string $typeName
     */
    public function __construct($name = null, $price = null, $rateID = null, $typeName = null)
    {
        $this
            ->setName($name)
            ->setPrice($price)
            ->setRateID($rateID)
            ->setTypeName($typeName);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RateInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return RateInformation
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get rateID value
     * @return int|null
     */
    public function getRateID()
    {
        return $this->rateID;
    }
    /**
     * Set rateID value
     * @param int $rateID
     * @return RateInformation
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !(is_int($rateID) || ctype_digit($rateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rateID, true), gettype($rateID)), __LINE__);
        }
        $this->rateID = $rateID;
        return $this;
    }
    /**
     * Get typeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->typeName;
    }
    /**
     * Set typeName value
     * @param string $typeName
     * @return RateInformation
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        $this->typeName = $typeName;
        return $this;
    }
}
