<?php
use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for payer Enums
 * @subpackage Enumerations
 */
class Payer extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SENDER'
     * @return string 'SENDER'
     */
    const VALUE_SENDER = 'SENDER';
    /**
     * Constant for value 'SENDER_WITH_TAX'
     * @return string 'SENDER_WITH_TAX'
     */
    const VALUE_SENDER_WITH_TAX = 'SENDER_WITH_TAX';
    /**
     * Constant for value 'RECEIVER'
     * @return string 'RECEIVER'
     */
    const VALUE_RECEIVER = 'RECEIVER';
    /**
     * Constant for value 'THIRD_PARTY'
     * @return string 'THIRD_PARTY'
     */
    const VALUE_THIRD_PARTY = 'THIRD_PARTY';
    /**
     * Return allowed values
     * @uses self::VALUE_SENDER
     * @uses self::VALUE_SENDER_WITH_TAX
     * @uses self::VALUE_RECEIVER
     * @uses self::VALUE_THIRD_PARTY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SENDER,
            self::VALUE_SENDER_WITH_TAX,
            self::VALUE_RECEIVER,
            self::VALUE_THIRD_PARTY,
        );
    }
}
