<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelResponse Structure
 * @subpackage Structs
 */
class ParcelResponse extends AbstractStructBase
{
    /**
     * The externalTrackingLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $externalTrackingLink;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The parcelID
     * @var int
     */
    public $parcelID;
    /**
     * Constructor method for parcelResponse
     * @uses ParcelResponse::setExternalTrackingLink()
     * @uses ParcelResponse::setLabel()
     * @uses ParcelResponse::setParcelID()
     * @param string $externalTrackingLink
     * @param string $label
     * @param int $parcelID
     */
    public function __construct($externalTrackingLink = null, $label = null, $parcelID = null)
    {
        $this
            ->setExternalTrackingLink($externalTrackingLink)
            ->setLabel($label)
            ->setParcelID($parcelID);
    }
    /**
     * Get externalTrackingLink value
     * @return string|null
     */
    public function getExternalTrackingLink()
    {
        return $this->externalTrackingLink;
    }
    /**
     * Set externalTrackingLink value
     * @param string $externalTrackingLink
     * @return ParcelResponse
     */
    public function setExternalTrackingLink($externalTrackingLink = null)
    {
        // validation for constraint: string
        if (!is_null($externalTrackingLink) && !is_string($externalTrackingLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTrackingLink, true), gettype($externalTrackingLink)), __LINE__);
        }
        $this->externalTrackingLink = $externalTrackingLink;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return ParcelResponse
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get parcelID value
     * @return int|null
     */
    public function getParcelID()
    {
        return $this->parcelID;
    }
    /**
     * Set parcelID value
     * @param int $parcelID
     * @return ParcelResponse
     */
    public function setParcelID($parcelID = null)
    {
        // validation for constraint: int
        if (!is_null($parcelID) && !(is_int($parcelID) || ctype_digit($parcelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelID, true), gettype($parcelID)), __LINE__);
        }
        $this->parcelID = $parcelID;
        return $this;
    }
}
