<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for manifestResponseType Structure
 * @subpackage Structs
 */
class ManifestResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The manifestPDF
     * @var string
     */
    public $manifestPDF;
    /**
     * Constructor method for manifestResponseType
     * @uses ManifestResponseType::setStatus()
     * @uses ManifestResponseType::setManifestPDF()
     * @param Status $status
     * @param string $manifestPDF
     */
    public function __construct(Status $status = null, $manifestPDF = null)
    {
        $this
            ->setStatus($status)
            ->setManifestPDF($manifestPDF);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return ManifestResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get manifestPDF value
     * @return string|null
     */
    public function getManifestPDF()
    {
        return $this->manifestPDF;
    }
    /**
     * Set manifestPDF value
     * @param string $manifestPDF
     * @return ManifestResponseType
     */
    public function setManifestPDF($manifestPDF = null)
    {
        // validation for constraint: string
        if (!is_null($manifestPDF) && !is_string($manifestPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestPDF, true), gettype($manifestPDF)), __LINE__);
        }
        $this->manifestPDF = $manifestPDF;
        return $this;
    }
}
