<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for manifestRequest Structure
 * @subpackage Structs
 */
class ManifestRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The manifestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manifestDate;
    /**
     * Constructor method for manifestRequest
     * @uses ManifestRequest::setCredentials()
     * @uses ManifestRequest::setManifestDate()
     * @param Credential $credentials
     * @param string $manifestDate
     */
    public function __construct(Credential $credentials = null, $manifestDate = null)
    {
        $this
            ->setCredentials($credentials)
            ->setManifestDate($manifestDate);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return ManifestRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get manifestDate value
     * @return string|null
     */
    public function getManifestDate()
    {
        return $this->manifestDate;
    }
    /**
     * Set manifestDate value
     * @param string $manifestDate
     * @return ManifestRequest
     */
    public function setManifestDate($manifestDate = null)
    {
        // validation for constraint: string
        if (!is_null($manifestDate) && !is_string($manifestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestDate, true), gettype($manifestDate)), __LINE__);
        }
        $this->manifestDate = $manifestDate;
        return $this;
    }
}
