<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for labelsResponse Structure
 * @subpackage Structs
 */
class LabelsResponse extends AbstractStructBase
{
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The labels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $labels;
    /**
     * The labelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelType;
    /**
     * Constructor method for labelsResponse
     * @uses LabelsResponse::setConsignmentID()
     * @uses LabelsResponse::setLabels()
     * @uses LabelsResponse::setLabelType()
     * @param int $consignmentID
     * @param string[] $labels
     * @param string $labelType
     */
    public function __construct($consignmentID = null, array $labels = array(), $labelType = null)
    {
        $this
            ->setConsignmentID($consignmentID)
            ->setLabels($labels)
            ->setLabelType($labelType);
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return LabelsResponse
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get labels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLabels()
    {
        return isset($this->labels) ? $this->labels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLabels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelsForArrayConstraintsFromSetLabels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $labelsResponseLabelsItem) {
            // validation for constraint: itemType
            if (!is_string($labelsResponseLabelsItem)) {
                $invalidValues[] = is_object($labelsResponseLabelsItem) ? get_class($labelsResponseLabelsItem) : sprintf('%s(%s)', gettype($labelsResponseLabelsItem), var_export($labelsResponseLabelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The labels property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set labels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $labels
     * @return LabelsResponse
     */
    public function setLabels(array $labels = array())
    {
        // validation for constraint: array
        if ('' !== ($labelsArrayErrorMessage = self::validateLabelsForArrayConstraintsFromSetLabels($labels))) {
            throw new \InvalidArgumentException($labelsArrayErrorMessage, __LINE__);
        }
        if (is_null($labels) || (is_array($labels) && empty($labels))) {
            unset($this->labels);
        } else {
            $this->labels = $labels;
        }
        return $this;
    }
    /**
     * Add item to labels value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return LabelsResponse
     */
    public function addToLabels($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The labels property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->labels[] = $item;
        return $this;
    }
    /**
     * Get labelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->labelType;
    }
    /**
     * Set labelType value
     * @uses LabelType::valueIsValid()
     * @uses LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return LabelsResponse
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', LabelType::getValidValues())), __LINE__);
        }
        $this->labelType = $labelType;
        return $this;
    }
}
