<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for costRequest Structure
 * @subpackage Structs
 */
class CostRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The consignmentIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $consignmentIDs;
    /**
     * The showDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showDetails;
    /**
     * Constructor method for costRequest
     * @uses CostRequest::setCredentials()
     * @uses CostRequest::setConsignmentIDs()
     * @uses CostRequest::setShowDetails()
     * @param Credential $credentials
     * @param int[] $consignmentIDs
     * @param bool $showDetails
     */
    public function __construct(Credential $credentials = null, array $consignmentIDs = array(), $showDetails = null)
    {
        $this
            ->setCredentials($credentials)
            ->setConsignmentIDs($consignmentIDs)
            ->setShowDetails($showDetails);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return CostRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get consignmentIDs value
     * @return int[]|null
     */
    public function getConsignmentIDs()
    {
        return $this->consignmentIDs;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentIDs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentIDs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costRequestConsignmentIDsItem) {
            // validation for constraint: itemType
            if (!(is_int($costRequestConsignmentIDsItem) || ctype_digit($costRequestConsignmentIDsItem))) {
                $invalidValues[] = is_object($costRequestConsignmentIDsItem) ? get_class($costRequestConsignmentIDsItem) : sprintf('%s(%s)', gettype($costRequestConsignmentIDsItem), var_export($costRequestConsignmentIDsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int[] $consignmentIDs
     * @return CostRequest
     */
    public function setConsignmentIDs(array $consignmentIDs = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentIDsArrayErrorMessage = self::validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs($consignmentIDs))) {
            throw new \InvalidArgumentException($consignmentIDsArrayErrorMessage, __LINE__);
        }
        $this->consignmentIDs = $consignmentIDs;
        return $this;
    }
    /**
     * Add item to consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return CostRequest
     */
    public function addToConsignmentIDs($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignmentIDs[] = $item;
        return $this;
    }
    /**
     * Get showDetails value
     * @return bool|null
     */
    public function getShowDetails()
    {
        return $this->showDetails;
    }
    /**
     * Set showDetails value
     * @param bool $showDetails
     * @return CostRequest
     */
    public function setShowDetails($showDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDetails) && !is_bool($showDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDetails, true), gettype($showDetails)), __LINE__);
        }
        $this->showDetails = $showDetails;
        return $this;
    }
}
