<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consignmentResponse Structure
 * @subpackage Structs
 */
class ConsignmentResponse extends AbstractStructBase
{
    /**
     * The consignmentID
     * @var int
     */
    public $consignmentID;
    /**
     * The yourReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yourReference;
    /**
     * The trackingUrl
     * @var string
     */
    public $trackingUrl;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The autoBooked
     * @var bool
     */
    public $autoBooked;
    /**
     * The autoBookResponse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $autoBookResponse;
    /**
     * The bookLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bookLabel;
    /**
     * The parcelResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ParcelResponse[]
     */
    public $parcelResponses;
    /**
     * Constructor method for consignmentResponse
     * @uses ConsignmentResponse::setConsignmentID()
     * @uses ConsignmentResponse::setYourReference()
     * @uses ConsignmentResponse::setTrackingUrl()
     * @uses ConsignmentResponse::setPrice()
     * @uses ConsignmentResponse::setAutoBooked()
     * @uses ConsignmentResponse::setAutoBookResponse()
     * @uses ConsignmentResponse::setBookLabel()
     * @uses ConsignmentResponse::setParcelResponses()
     * @param int $consignmentID
     * @param string $yourReference
     * @param string $trackingUrl
     * @param float $price
     * @param bool $autoBooked
     * @param string $autoBookResponse
     * @param string $bookLabel
     * @param ParcelResponse[] $parcelResponses
     */
    public function __construct($consignmentID = null, $yourReference = null, $trackingUrl = null, $price = null, $autoBooked = null, $autoBookResponse = null, $bookLabel = null, array $parcelResponses = array())
    {
        $this
            ->setConsignmentID($consignmentID)
            ->setYourReference($yourReference)
            ->setTrackingUrl($trackingUrl)
            ->setPrice($price)
            ->setAutoBooked($autoBooked)
            ->setAutoBookResponse($autoBookResponse)
            ->setBookLabel($bookLabel)
            ->setParcelResponses($parcelResponses);
    }
    /**
     * Get consignmentID value
     * @return int|null
     */
    public function getConsignmentID()
    {
        return $this->consignmentID;
    }
    /**
     * Set consignmentID value
     * @param int $consignmentID
     * @return ConsignmentResponse
     */
    public function setConsignmentID($consignmentID = null)
    {
        // validation for constraint: int
        if (!is_null($consignmentID) && !(is_int($consignmentID) || ctype_digit($consignmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consignmentID, true), gettype($consignmentID)), __LINE__);
        }
        $this->consignmentID = $consignmentID;
        return $this;
    }
    /**
     * Get yourReference value
     * @return string|null
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }
    /**
     * Set yourReference value
     * @param string $yourReference
     * @return ConsignmentResponse
     */
    public function setYourReference($yourReference = null)
    {
        // validation for constraint: string
        if (!is_null($yourReference) && !is_string($yourReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yourReference, true), gettype($yourReference)), __LINE__);
        }
        $this->yourReference = $yourReference;
        return $this;
    }
    /**
     * Get trackingUrl value
     * @return string|null
     */
    public function getTrackingUrl()
    {
        return $this->trackingUrl;
    }
    /**
     * Set trackingUrl value
     * @param string $trackingUrl
     * @return ConsignmentResponse
     */
    public function setTrackingUrl($trackingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrl) && !is_string($trackingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrl, true), gettype($trackingUrl)), __LINE__);
        }
        $this->trackingUrl = $trackingUrl;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return ConsignmentResponse
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get autoBooked value
     * @return bool|null
     */
    public function getAutoBooked()
    {
        return $this->autoBooked;
    }
    /**
     * Set autoBooked value
     * @param bool $autoBooked
     * @return ConsignmentResponse
     */
    public function setAutoBooked($autoBooked = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoBooked) && !is_bool($autoBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoBooked, true), gettype($autoBooked)), __LINE__);
        }
        $this->autoBooked = $autoBooked;
        return $this;
    }
    /**
     * Get autoBookResponse value
     * @return string|null
     */
    public function getAutoBookResponse()
    {
        return $this->autoBookResponse;
    }
    /**
     * Set autoBookResponse value
     * @param string $autoBookResponse
     * @return ConsignmentResponse
     */
    public function setAutoBookResponse($autoBookResponse = null)
    {
        // validation for constraint: string
        if (!is_null($autoBookResponse) && !is_string($autoBookResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoBookResponse, true), gettype($autoBookResponse)), __LINE__);
        }
        $this->autoBookResponse = $autoBookResponse;
        return $this;
    }
    /**
     * Get bookLabel value
     * @return string|null
     */
    public function getBookLabel()
    {
        return $this->bookLabel;
    }
    /**
     * Set bookLabel value
     * @param string $bookLabel
     * @return ConsignmentResponse
     */
    public function setBookLabel($bookLabel = null)
    {
        // validation for constraint: string
        if (!is_null($bookLabel) && !is_string($bookLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookLabel, true), gettype($bookLabel)), __LINE__);
        }
        $this->bookLabel = $bookLabel;
        return $this;
    }
    /**
     * Get parcelResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ParcelResponse[]|null
     */
    public function getParcelResponses()
    {
        return isset($this->parcelResponses) ? $this->parcelResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelResponsesForArrayConstraintsFromSetParcelResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentResponseParcelResponsesItem) {
            // validation for constraint: itemType
            if (!$consignmentResponseParcelResponsesItem instanceof ParcelResponse) {
                $invalidValues[] = is_object($consignmentResponseParcelResponsesItem) ? get_class($consignmentResponseParcelResponsesItem) : sprintf('%s(%s)', gettype($consignmentResponseParcelResponsesItem), var_export($consignmentResponseParcelResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcelResponses property can only contain items of type ParcelResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcelResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ParcelResponse[] $parcelResponses
     * @return ConsignmentResponse
     */
    public function setParcelResponses(array $parcelResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelResponsesArrayErrorMessage = self::validateParcelResponsesForArrayConstraintsFromSetParcelResponses($parcelResponses))) {
            throw new \InvalidArgumentException($parcelResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($parcelResponses) || (is_array($parcelResponses) && empty($parcelResponses))) {
            unset($this->parcelResponses);
        } else {
            $this->parcelResponses = $parcelResponses;
        }
        return $this;
    }
    /**
     * Add item to parcelResponses value
     * @throws \InvalidArgumentException
     * @param ParcelResponse $item
     * @return ConsignmentResponse
     */
    public function addToParcelResponses(ParcelResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ParcelResponse) {
            throw new \InvalidArgumentException(sprintf('The parcelResponses property can only contain items of type ParcelResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcelResponses[] = $item;
        return $this;
    }
}
