<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookRequest Structure
 * @subpackage Structs
 */
class BookRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The consignments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var Consignment[]
     */
    public $consignments;
    /**
     * Constructor method for bookRequest
     * @uses BookRequest::setCredentials()
     * @uses BookRequest::setConsignments()
     * @param Credential $credentials
     * @param Consignment[] $consignments
     */
    public function __construct(Credential $credentials = null, array $consignments = array())
    {
        $this
            ->setCredentials($credentials)
            ->setConsignments($consignments);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return BookRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get consignments value
     * @return Consignment[]|null
     */
    public function getConsignments()
    {
        return $this->consignments;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentsForArrayConstraintsFromSetConsignments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookRequestConsignmentsItem) {
            // validation for constraint: itemType
            if (!$bookRequestConsignmentsItem instanceof Consignment) {
                $invalidValues[] = is_object($bookRequestConsignmentsItem) ? get_class($bookRequestConsignmentsItem) : sprintf('%s(%s)', gettype($bookRequestConsignmentsItem), var_export($bookRequestConsignmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignments property can only contain items of type Consignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignments value
     * @throws \InvalidArgumentException
     * @param Consignment[] $consignments
     * @return BookRequest
     */
    public function setConsignments(array $consignments = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentsArrayErrorMessage = self::validateConsignmentsForArrayConstraintsFromSetConsignments($consignments))) {
            throw new \InvalidArgumentException($consignmentsArrayErrorMessage, __LINE__);
        }
        $this->consignments = $consignments;
        return $this;
    }
    /**
     * Add item to consignments value
     * @throws \InvalidArgumentException
     * @param Consignment $item
     * @return BookRequest
     */
    public function addToConsignments(Consignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Consignment) {
            throw new \InvalidArgumentException(sprintf('The consignments property can only contain items of type Consignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignments[] = $item;
        return $this;
    }
}
