<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printLabelsRequest Structure
 * @subpackage Structs
 */
class PrintLabelsRequest extends AbstractStructBase
{
    /**
     * The credentials
     * @var Credential
     */
    public $credentials;
    /**
     * The consignmentIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $consignmentIDs;
    /**
     * Constructor method for printLabelsRequest
     * @uses PrintLabelsRequest::setCredentials()
     * @uses PrintLabelsRequest::setConsignmentIDs()
     * @param Credential $credentials
     * @param int[] $consignmentIDs
     */
    public function __construct(Credential $credentials = null, array $consignmentIDs = array())
    {
        $this
            ->setCredentials($credentials)
            ->setConsignmentIDs($consignmentIDs);
    }
    /**
     * Get credentials value
     * @return Credential|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param Credential $credentials
     * @return PrintLabelsRequest
     */
    public function setCredentials(Credential $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get consignmentIDs value
     * @return int[]|null
     */
    public function getConsignmentIDs()
    {
        return $this->consignmentIDs;
    }
    /**
     * This method is responsible for validating the values passed to the setConsignmentIDs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsignmentIDs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printLabelsRequestConsignmentIDsItem) {
            // validation for constraint: itemType
            if (!(is_int($printLabelsRequestConsignmentIDsItem) || ctype_digit($printLabelsRequestConsignmentIDsItem))) {
                $invalidValues[] = is_object($printLabelsRequestConsignmentIDsItem) ? get_class($printLabelsRequestConsignmentIDsItem) : sprintf('%s(%s)', gettype($printLabelsRequestConsignmentIDsItem), var_export($printLabelsRequestConsignmentIDsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int[] $consignmentIDs
     * @return PrintLabelsRequest
     */
    public function setConsignmentIDs(array $consignmentIDs = array())
    {
        // validation for constraint: array
        if ('' !== ($consignmentIDsArrayErrorMessage = self::validateConsignmentIDsForArrayConstraintsFromSetConsignmentIDs($consignmentIDs))) {
            throw new \InvalidArgumentException($consignmentIDsArrayErrorMessage, __LINE__);
        }
        $this->consignmentIDs = $consignmentIDs;
        return $this;
    }
    /**
     * Add item to consignmentIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return PrintLabelsRequest
     */
    public function addToConsignmentIDs($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The consignmentIDs property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consignmentIDs[] = $item;
        return $this;
    }
}
