<?php
use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for costStatus Enums
 * @subpackage Enumerations
 */
class CostStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NOT_AVAILABLE'
     * @return string 'NOT_AVAILABLE'
     */
    const VALUE_NOT_AVAILABLE = 'NOT_AVAILABLE';
    /**
     * Constant for value 'NOT_INVOICED'
     * @return string 'NOT_INVOICED'
     */
    const VALUE_NOT_INVOICED = 'NOT_INVOICED';
    /**
     * Constant for value 'PRELIMINARY'
     * @return string 'PRELIMINARY'
     */
    const VALUE_PRELIMINARY = 'PRELIMINARY';
    /**
     * Constant for value 'FINAL'
     * @return string 'FINAL'
     */
    const VALUE_FINAL = 'FINAL';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_AVAILABLE
     * @uses self::VALUE_NOT_INVOICED
     * @uses self::VALUE_PRELIMINARY
     * @uses self::VALUE_FINAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_AVAILABLE,
            self::VALUE_NOT_INVOICED,
            self::VALUE_PRELIMINARY,
            self::VALUE_FINAL,
        );
    }
}
