<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consignment Structure
 * @subpackage Structs
 */
class Consignment extends AbstractStructBase
{
    /**
     * The receiverParty
     * @var Party
     */
    public $receiverParty;
    /**
     * The pickupParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var Party
     */
    public $pickupParty;
    /**
     * The payerParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var Party
     */
    public $payerParty;
    /**
     * The pickupInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var Information
     */
    public $pickupInformation;
    /**
     * The receiverInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var Information
     */
    public $receiverInformation;
    /**
     * The payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payer;
    /**
     * The pickupDate
     * @var string
     */
    public $pickupDate;
    /**
     * The externalPickup
     * @var bool
     */
    public $externalPickup;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryDate;
    /**
     * The deliveryTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryTimeFrom;
    /**
     * The deliveryTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryTimeTo;
    /**
     * The shipAlert
     * @var bool
     */
    public $shipAlert;
    /**
     * The yourReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $yourReference;
    /**
     * The reference1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference1;
    /**
     * The reference2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference2;
    /**
     * The costCentre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costCentre;
    /**
     * The atcNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $atcNumber;
    /**
     * The mrn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mrn;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The customRateID
     * @var int
     */
    public $customRateID;
    /**
     * The typeOfGoods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeOfGoods;
    /**
     * The valueOfGoods
     * @var float
     */
    public $valueOfGoods;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The insurance
     * @var bool
     */
    public $insurance;
    /**
     * The thirdPartyCustomerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyCustomerNumber;
    /**
     * The thirdPartyCustomerPostalcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirdPartyCustomerPostalcode;
    /**
     * The printLabel
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $printLabel;
    /**
     * The labelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelType;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var Parcel[]
     */
    public $parcels;
    /**
     * Constructor method for consignment
     * @uses Consignment::setReceiverParty()
     * @uses Consignment::setPickupParty()
     * @uses Consignment::setPayerParty()
     * @uses Consignment::setPickupInformation()
     * @uses Consignment::setReceiverInformation()
     * @uses Consignment::setPayer()
     * @uses Consignment::setPickupDate()
     * @uses Consignment::setExternalPickup()
     * @uses Consignment::setPickupTimeFrom()
     * @uses Consignment::setPickupTimeTo()
     * @uses Consignment::setDeliveryDate()
     * @uses Consignment::setDeliveryTimeFrom()
     * @uses Consignment::setDeliveryTimeTo()
     * @uses Consignment::setShipAlert()
     * @uses Consignment::setYourReference()
     * @uses Consignment::setReference1()
     * @uses Consignment::setReference2()
     * @uses Consignment::setCostCentre()
     * @uses Consignment::setAtcNumber()
     * @uses Consignment::setMrn()
     * @uses Consignment::setMemo()
     * @uses Consignment::setRate()
     * @uses Consignment::setCustomRateID()
     * @uses Consignment::setTypeOfGoods()
     * @uses Consignment::setValueOfGoods()
     * @uses Consignment::setCurrency()
     * @uses Consignment::setInsurance()
     * @uses Consignment::setThirdPartyCustomerNumber()
     * @uses Consignment::setThirdPartyCustomerPostalcode()
     * @uses Consignment::setPrintLabel()
     * @uses Consignment::setLabelType()
     * @uses Consignment::setParcels()
     * @param Party $receiverParty
     * @param Party $pickupParty
     * @param Party $payerParty
     * @param Information $pickupInformation
     * @param Information $receiverInformation
     * @param string $payer
     * @param string $pickupDate
     * @param bool $externalPickup
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $deliveryDate
     * @param string $deliveryTimeFrom
     * @param string $deliveryTimeTo
     * @param bool $shipAlert
     * @param string $yourReference
     * @param string $reference1
     * @param string $reference2
     * @param string $costCentre
     * @param string $atcNumber
     * @param string $mrn
     * @param string $memo
     * @param string $rate
     * @param int $customRateID
     * @param string $typeOfGoods
     * @param float $valueOfGoods
     * @param string $currency
     * @param bool $insurance
     * @param string $thirdPartyCustomerNumber
     * @param string $thirdPartyCustomerPostalcode
     * @param bool $printLabel
     * @param string $labelType
     * @param Parcel[] $parcels
     */
    public function __construct(Party $receiverParty = null, Party $pickupParty = null, Party $payerParty = null, Information $pickupInformation = null, Information $receiverInformation = null, $payer = null, $pickupDate = null, $externalPickup = null, $pickupTimeFrom = null, $pickupTimeTo = null, $deliveryDate = null, $deliveryTimeFrom = null, $deliveryTimeTo = null, $shipAlert = null, $yourReference = null, $reference1 = null, $reference2 = null, $costCentre = null, $atcNumber = null, $mrn = null, $memo = null, $rate = null, $customRateID = null, $typeOfGoods = null, $valueOfGoods = null, $currency = null, $insurance = null, $thirdPartyCustomerNumber = null, $thirdPartyCustomerPostalcode = null, $printLabel = true, $labelType = null, array $parcels = array())
    {
        $this
            ->setReceiverParty($receiverParty)
            ->setPickupParty($pickupParty)
            ->setPayerParty($payerParty)
            ->setPickupInformation($pickupInformation)
            ->setReceiverInformation($receiverInformation)
            ->setPayer($payer)
            ->setPickupDate($pickupDate)
            ->setExternalPickup($externalPickup)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryTimeFrom($deliveryTimeFrom)
            ->setDeliveryTimeTo($deliveryTimeTo)
            ->setShipAlert($shipAlert)
            ->setYourReference($yourReference)
            ->setReference1($reference1)
            ->setReference2($reference2)
            ->setCostCentre($costCentre)
            ->setAtcNumber($atcNumber)
            ->setMrn($mrn)
            ->setMemo($memo)
            ->setRate($rate)
            ->setCustomRateID($customRateID)
            ->setTypeOfGoods($typeOfGoods)
            ->setValueOfGoods($valueOfGoods)
            ->setCurrency($currency)
            ->setInsurance($insurance)
            ->setThirdPartyCustomerNumber($thirdPartyCustomerNumber)
            ->setThirdPartyCustomerPostalcode($thirdPartyCustomerPostalcode)
            ->setPrintLabel($printLabel)
            ->setLabelType($labelType)
            ->setParcels($parcels);
    }
    /**
     * Get receiverParty value
     * @return Party|null
     */
    public function getReceiverParty()
    {
        return $this->receiverParty;
    }
    /**
     * Set receiverParty value
     * @param Party $receiverParty
     * @return Consignment
     */
    public function setReceiverParty(Party $receiverParty = null)
    {
        $this->receiverParty = $receiverParty;
        return $this;
    }
    /**
     * Get pickupParty value
     * @return Party|null
     */
    public function getPickupParty()
    {
        return $this->pickupParty;
    }
    /**
     * Set pickupParty value
     * @param Party $pickupParty
     * @return Consignment
     */
    public function setPickupParty(Party $pickupParty = null)
    {
        $this->pickupParty = $pickupParty;
        return $this;
    }
    /**
     * Get payerParty value
     * @return Party|null
     */
    public function getPayerParty()
    {
        return $this->payerParty;
    }
    /**
     * Set payerParty value
     * @param Party $payerParty
     * @return Consignment
     */
    public function setPayerParty(Party $payerParty = null)
    {
        $this->payerParty = $payerParty;
        return $this;
    }
    /**
     * Get pickupInformation value
     * @return Information|null
     */
    public function getPickupInformation()
    {
        return $this->pickupInformation;
    }
    /**
     * Set pickupInformation value
     * @param Information $pickupInformation
     * @return Consignment
     */
    public function setPickupInformation(Information $pickupInformation = null)
    {
        $this->pickupInformation = $pickupInformation;
        return $this;
    }
    /**
     * Get receiverInformation value
     * @return Information|null
     */
    public function getReceiverInformation()
    {
        return $this->receiverInformation;
    }
    /**
     * Set receiverInformation value
     * @param Information $receiverInformation
     * @return Consignment
     */
    public function setReceiverInformation(Information $receiverInformation = null)
    {
        $this->receiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get payer value
     * @return string|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @uses Payer::valueIsValid()
     * @uses Payer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payer
     * @return Consignment
     */
    public function setPayer($payer = null)
    {
        // validation for constraint: enumeration
        if (!Payer::valueIsValid($payer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class Payer', is_array($payer) ? implode(', ', $payer) : var_export($payer, true), implode(', ', Payer::getValidValues())), __LINE__);
        }
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return Consignment
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get externalPickup value
     * @return bool|null
     */
    public function getExternalPickup()
    {
        return $this->externalPickup;
    }
    /**
     * Set externalPickup value
     * @param bool $externalPickup
     * @return Consignment
     */
    public function setExternalPickup($externalPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($externalPickup) && !is_bool($externalPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($externalPickup, true), gettype($externalPickup)), __LINE__);
        }
        $this->externalPickup = $externalPickup;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return Consignment
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return Consignment
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get deliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return Consignment
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get deliveryTimeFrom value
     * @return string|null
     */
    public function getDeliveryTimeFrom()
    {
        return $this->deliveryTimeFrom;
    }
    /**
     * Set deliveryTimeFrom value
     * @param string $deliveryTimeFrom
     * @return Consignment
     */
    public function setDeliveryTimeFrom($deliveryTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeFrom) && !is_string($deliveryTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeFrom, true), gettype($deliveryTimeFrom)), __LINE__);
        }
        $this->deliveryTimeFrom = $deliveryTimeFrom;
        return $this;
    }
    /**
     * Get deliveryTimeTo value
     * @return string|null
     */
    public function getDeliveryTimeTo()
    {
        return $this->deliveryTimeTo;
    }
    /**
     * Set deliveryTimeTo value
     * @param string $deliveryTimeTo
     * @return Consignment
     */
    public function setDeliveryTimeTo($deliveryTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeTo) && !is_string($deliveryTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeTo, true), gettype($deliveryTimeTo)), __LINE__);
        }
        $this->deliveryTimeTo = $deliveryTimeTo;
        return $this;
    }
    /**
     * Get shipAlert value
     * @return bool|null
     */
    public function getShipAlert()
    {
        return $this->shipAlert;
    }
    /**
     * Set shipAlert value
     * @param bool $shipAlert
     * @return Consignment
     */
    public function setShipAlert($shipAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipAlert) && !is_bool($shipAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipAlert, true), gettype($shipAlert)), __LINE__);
        }
        $this->shipAlert = $shipAlert;
        return $this;
    }
    /**
     * Get yourReference value
     * @return string|null
     */
    public function getYourReference()
    {
        return $this->yourReference;
    }
    /**
     * Set yourReference value
     * @param string $yourReference
     * @return Consignment
     */
    public function setYourReference($yourReference = null)
    {
        // validation for constraint: string
        if (!is_null($yourReference) && !is_string($yourReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yourReference, true), gettype($yourReference)), __LINE__);
        }
        $this->yourReference = $yourReference;
        return $this;
    }
    /**
     * Get reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->reference1;
    }
    /**
     * Set reference1 value
     * @param string $reference1
     * @return Consignment
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference1, true), gettype($reference1)), __LINE__);
        }
        $this->reference1 = $reference1;
        return $this;
    }
    /**
     * Get reference2 value
     * @return string|null
     */
    public function getReference2()
    {
        return $this->reference2;
    }
    /**
     * Set reference2 value
     * @param string $reference2
     * @return Consignment
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference2, true), gettype($reference2)), __LINE__);
        }
        $this->reference2 = $reference2;
        return $this;
    }
    /**
     * Get costCentre value
     * @return string|null
     */
    public function getCostCentre()
    {
        return $this->costCentre;
    }
    /**
     * Set costCentre value
     * @param string $costCentre
     * @return Consignment
     */
    public function setCostCentre($costCentre = null)
    {
        // validation for constraint: string
        if (!is_null($costCentre) && !is_string($costCentre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentre, true), gettype($costCentre)), __LINE__);
        }
        $this->costCentre = $costCentre;
        return $this;
    }
    /**
     * Get atcNumber value
     * @return string|null
     */
    public function getAtcNumber()
    {
        return $this->atcNumber;
    }
    /**
     * Set atcNumber value
     * @param string $atcNumber
     * @return Consignment
     */
    public function setAtcNumber($atcNumber = null)
    {
        // validation for constraint: string
        if (!is_null($atcNumber) && !is_string($atcNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atcNumber, true), gettype($atcNumber)), __LINE__);
        }
        $this->atcNumber = $atcNumber;
        return $this;
    }
    /**
     * Get mrn value
     * @return string|null
     */
    public function getMrn()
    {
        return $this->mrn;
    }
    /**
     * Set mrn value
     * @param string $mrn
     * @return Consignment
     */
    public function setMrn($mrn = null)
    {
        // validation for constraint: string
        if (!is_null($mrn) && !is_string($mrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mrn, true), gettype($mrn)), __LINE__);
        }
        $this->mrn = $mrn;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return Consignment
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @uses Rate::valueIsValid()
     * @uses Rate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rate
     * @return Consignment
     */
    public function setRate($rate = null)
    {
        // validation for constraint: enumeration
        if (!Rate::valueIsValid($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class Rate', is_array($rate) ? implode(', ', $rate) : var_export($rate, true), implode(', ', Rate::getValidValues())), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get customRateID value
     * @return int|null
     */
    public function getCustomRateID()
    {
        return $this->customRateID;
    }
    /**
     * Set customRateID value
     * @param int $customRateID
     * @return Consignment
     */
    public function setCustomRateID($customRateID = null)
    {
        // validation for constraint: int
        if (!is_null($customRateID) && !(is_int($customRateID) || ctype_digit($customRateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customRateID, true), gettype($customRateID)), __LINE__);
        }
        $this->customRateID = $customRateID;
        return $this;
    }
    /**
     * Get typeOfGoods value
     * @return string|null
     */
    public function getTypeOfGoods()
    {
        return $this->typeOfGoods;
    }
    /**
     * Set typeOfGoods value
     * @uses TypeOfGoods::valueIsValid()
     * @uses TypeOfGoods::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfGoods
     * @return Consignment
     */
    public function setTypeOfGoods($typeOfGoods = null)
    {
        // validation for constraint: enumeration
        if (!TypeOfGoods::valueIsValid($typeOfGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TypeOfGoods', is_array($typeOfGoods) ? implode(', ', $typeOfGoods) : var_export($typeOfGoods, true), implode(', ', TypeOfGoods::getValidValues())), __LINE__);
        }
        $this->typeOfGoods = $typeOfGoods;
        return $this;
    }
    /**
     * Get valueOfGoods value
     * @return float|null
     */
    public function getValueOfGoods()
    {
        return $this->valueOfGoods;
    }
    /**
     * Set valueOfGoods value
     * @param float $valueOfGoods
     * @return Consignment
     */
    public function setValueOfGoods($valueOfGoods = null)
    {
        // validation for constraint: float
        if (!is_null($valueOfGoods) && !(is_float($valueOfGoods) || is_numeric($valueOfGoods))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valueOfGoods, true), gettype($valueOfGoods)), __LINE__);
        }
        $this->valueOfGoods = $valueOfGoods;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses Currency::valueIsValid()
     * @uses Currency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return Consignment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!Currency::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class Currency', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', Currency::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get insurance value
     * @return bool|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param bool $insurance
     * @return Consignment
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($insurance) && !is_bool($insurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Get thirdPartyCustomerNumber value
     * @return string|null
     */
    public function getThirdPartyCustomerNumber()
    {
        return $this->thirdPartyCustomerNumber;
    }
    /**
     * Set thirdPartyCustomerNumber value
     * @param string $thirdPartyCustomerNumber
     * @return Consignment
     */
    public function setThirdPartyCustomerNumber($thirdPartyCustomerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyCustomerNumber) && !is_string($thirdPartyCustomerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyCustomerNumber, true), gettype($thirdPartyCustomerNumber)), __LINE__);
        }
        $this->thirdPartyCustomerNumber = $thirdPartyCustomerNumber;
        return $this;
    }
    /**
     * Get thirdPartyCustomerPostalcode value
     * @return string|null
     */
    public function getThirdPartyCustomerPostalcode()
    {
        return $this->thirdPartyCustomerPostalcode;
    }
    /**
     * Set thirdPartyCustomerPostalcode value
     * @param string $thirdPartyCustomerPostalcode
     * @return Consignment
     */
    public function setThirdPartyCustomerPostalcode($thirdPartyCustomerPostalcode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyCustomerPostalcode) && !is_string($thirdPartyCustomerPostalcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyCustomerPostalcode, true), gettype($thirdPartyCustomerPostalcode)), __LINE__);
        }
        $this->thirdPartyCustomerPostalcode = $thirdPartyCustomerPostalcode;
        return $this;
    }
    /**
     * Get printLabel value
     * @return bool|null
     */
    public function getPrintLabel()
    {
        return $this->printLabel;
    }
    /**
     * Set printLabel value
     * @param bool $printLabel
     * @return Consignment
     */
    public function setPrintLabel($printLabel = true)
    {
        // validation for constraint: boolean
        if (!is_null($printLabel) && !is_bool($printLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printLabel, true), gettype($printLabel)), __LINE__);
        }
        $this->printLabel = $printLabel;
        return $this;
    }
    /**
     * Get labelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->labelType;
    }
    /**
     * Set labelType value
     * @uses LabelType::valueIsValid()
     * @uses LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return Consignment
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', LabelType::getValidValues())), __LINE__);
        }
        $this->labelType = $labelType;
        return $this;
    }
    /**
     * Get parcels value
     * @return Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consignmentParcelsItem) {
            // validation for constraint: itemType
            if (!$consignmentParcelsItem instanceof Parcel) {
                $invalidValues[] = is_object($consignmentParcelsItem) ? get_class($consignmentParcelsItem) : sprintf('%s(%s)', gettype($consignmentParcelsItem), var_export($consignmentParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param Parcel[] $parcels
     * @return Consignment
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param Parcel $item
     * @return Consignment
     */
    public function addToParcels(Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
}
