<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelResponseType Structure
 * @subpackage Structs
 */
class CancelResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The cancelConsignmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $cancelConsignmentResponses;
    /**
     * The errorConsignmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $errorConsignmentResponses;
    /**
     * Constructor method for cancelResponseType
     * @uses CancelResponseType::setStatus()
     * @uses CancelResponseType::setCancelConsignmentResponses()
     * @uses CancelResponseType::setErrorConsignmentResponses()
     * @param Status $status
     * @param int[] $cancelConsignmentResponses
     * @param int[] $errorConsignmentResponses
     */
    public function __construct(Status $status = null, array $cancelConsignmentResponses = array(), array $errorConsignmentResponses = array())
    {
        $this
            ->setStatus($status)
            ->setCancelConsignmentResponses($cancelConsignmentResponses)
            ->setErrorConsignmentResponses($errorConsignmentResponses);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return CancelResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get cancelConsignmentResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getCancelConsignmentResponses()
    {
        return isset($this->cancelConsignmentResponses) ? $this->cancelConsignmentResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelConsignmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelConsignmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelConsignmentResponsesForArrayConstraintsFromSetCancelConsignmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelResponseTypeCancelConsignmentResponsesItem) {
            // validation for constraint: itemType
            if (!(is_int($cancelResponseTypeCancelConsignmentResponsesItem) || ctype_digit($cancelResponseTypeCancelConsignmentResponsesItem))) {
                $invalidValues[] = is_object($cancelResponseTypeCancelConsignmentResponsesItem) ? get_class($cancelResponseTypeCancelConsignmentResponsesItem) : sprintf('%s(%s)', gettype($cancelResponseTypeCancelConsignmentResponsesItem), var_export($cancelResponseTypeCancelConsignmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cancelConsignmentResponses property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cancelConsignmentResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $cancelConsignmentResponses
     * @return CancelResponseType
     */
    public function setCancelConsignmentResponses(array $cancelConsignmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelConsignmentResponsesArrayErrorMessage = self::validateCancelConsignmentResponsesForArrayConstraintsFromSetCancelConsignmentResponses($cancelConsignmentResponses))) {
            throw new \InvalidArgumentException($cancelConsignmentResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($cancelConsignmentResponses) || (is_array($cancelConsignmentResponses) && empty($cancelConsignmentResponses))) {
            unset($this->cancelConsignmentResponses);
        } else {
            $this->cancelConsignmentResponses = $cancelConsignmentResponses;
        }
        return $this;
    }
    /**
     * Add item to cancelConsignmentResponses value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return CancelResponseType
     */
    public function addToCancelConsignmentResponses($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The cancelConsignmentResponses property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cancelConsignmentResponses[] = $item;
        return $this;
    }
    /**
     * Get errorConsignmentResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getErrorConsignmentResponses()
    {
        return isset($this->errorConsignmentResponses) ? $this->errorConsignmentResponses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorConsignmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorConsignmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorConsignmentResponsesForArrayConstraintsFromSetErrorConsignmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelResponseTypeErrorConsignmentResponsesItem) {
            // validation for constraint: itemType
            if (!(is_int($cancelResponseTypeErrorConsignmentResponsesItem) || ctype_digit($cancelResponseTypeErrorConsignmentResponsesItem))) {
                $invalidValues[] = is_object($cancelResponseTypeErrorConsignmentResponsesItem) ? get_class($cancelResponseTypeErrorConsignmentResponsesItem) : sprintf('%s(%s)', gettype($cancelResponseTypeErrorConsignmentResponsesItem), var_export($cancelResponseTypeErrorConsignmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errorConsignmentResponses property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errorConsignmentResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $errorConsignmentResponses
     * @return CancelResponseType
     */
    public function setErrorConsignmentResponses(array $errorConsignmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($errorConsignmentResponsesArrayErrorMessage = self::validateErrorConsignmentResponsesForArrayConstraintsFromSetErrorConsignmentResponses($errorConsignmentResponses))) {
            throw new \InvalidArgumentException($errorConsignmentResponsesArrayErrorMessage, __LINE__);
        }
        if (is_null($errorConsignmentResponses) || (is_array($errorConsignmentResponses) && empty($errorConsignmentResponses))) {
            unset($this->errorConsignmentResponses);
        } else {
            $this->errorConsignmentResponses = $errorConsignmentResponses;
        }
        return $this;
    }
    /**
     * Add item to errorConsignmentResponses value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return CancelResponseType
     */
    public function addToErrorConsignmentResponses($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The errorConsignmentResponses property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errorConsignmentResponses[] = $item;
        return $this;
    }
}
