<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billResponseType Structure
 * @subpackage Structs
 */
class BillResponseType extends AbstractStructBase
{
    /**
     * The status
     * @var Status
     */
    public $status;
    /**
     * The bills
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Bill[]
     */
    public $bills;
    /**
     * Constructor method for billResponseType
     * @uses BillResponseType::setStatus()
     * @uses BillResponseType::setBills()
     * @param Status $status
     * @param Bill[] $bills
     */
    public function __construct(Status $status = null, array $bills = array())
    {
        $this
            ->setStatus($status)
            ->setBills($bills);
    }
    /**
     * Get status value
     * @return Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param Status $status
     * @return BillResponseType
     */
    public function setStatus(Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get bills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Bill[]|null
     */
    public function getBills()
    {
        return isset($this->bills) ? $this->bills : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBills method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBills method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillsForArrayConstraintsFromSetBills(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billResponseTypeBillsItem) {
            // validation for constraint: itemType
            if (!$billResponseTypeBillsItem instanceof Bill) {
                $invalidValues[] = is_object($billResponseTypeBillsItem) ? get_class($billResponseTypeBillsItem) : sprintf('%s(%s)', gettype($billResponseTypeBillsItem), var_export($billResponseTypeBillsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bills property can only contain items of type Bill, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Bill[] $bills
     * @return BillResponseType
     */
    public function setBills(array $bills = array())
    {
        // validation for constraint: array
        if ('' !== ($billsArrayErrorMessage = self::validateBillsForArrayConstraintsFromSetBills($bills))) {
            throw new \InvalidArgumentException($billsArrayErrorMessage, __LINE__);
        }
        if (is_null($bills) || (is_array($bills) && empty($bills))) {
            unset($this->bills);
        } else {
            $this->bills = $bills;
        }
        return $this;
    }
    /**
     * Add item to bills value
     * @throws \InvalidArgumentException
     * @param Bill $item
     * @return BillResponseType
     */
    public function addToBills(Bill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Bill) {
            throw new \InvalidArgumentException(sprintf('The bills property can only contain items of type Bill, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bills[] = $item;
        return $this;
    }
}
